/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Leon Chiver. All Rights Reserved.
 */
package org.netbeans.modules.java.hints;

import java.io.IOException;
import java.text.MessageFormat;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKind;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.editor.hints.spi.Hint;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

/**
 * @author leon chiver
 */
class InitializeVariableHint extends Hint {
    
    private String text;
    private VariableAccess variableAccess;
    
    InitializeVariableHint(VariableAccess access) {
        text = new MessageFormat(NbBundle.getMessage(InitializeVariableHint.class, "MSG_InitializeVar")).format(new Object[] { access.getName() });
        this.variableAccess = access;
    }
    
    public String getText() {
        return text;
    }
    
    public ChangeInfo implement() {
        ChangeInfo changeInfo = null;
        boolean fail = true;
        LocalVariable var = null;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            JavaModel.setClassPath(variableAccess.getResource());
            var = (LocalVariable) variableAccess.getElement();
            Type type = var.getType();
            String initVal;
            if (type instanceof PrimitiveType) {
                PrimitiveTypeKind primitiveType = ((PrimitiveType) type).getKind();
                if (PrimitiveTypeKindEnum.BOOLEAN.equals(primitiveType)) {
                    initVal = "false"; // NOI18N
                } else if (PrimitiveTypeKindEnum.CHAR.equals(primitiveType)) {
                    initVal = "'\\0'"; // NOI18N
                } else {
                    initVal = "0"; // NOI18N
                }
            } else {
                initVal = "null"; // NOI18N
            }
            var.setInitialValueText(initVal);
            fail = false;
        } finally {
            JavaModel.getJavaRepository().endTrans(fail);
        }
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            if (var != null && var.isValid()) {
                PositionBounds bounds = JavaMetamodel.getManager().getElementPosition(var.getInitialValue());
                changeInfo = new ChangeInfo(bounds.getBegin().getPosition(), bounds.getEnd().getPosition());
            }
        } catch (IOException e) {
            ErrorManager.getDefault().notify(e);
        } finally {
            JavaModel.getJavaRepository().endTrans();
        }
        return changeInfo;
    }
    
    public int getType() {
        return ERROR;
    }
    
}
