/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.hints;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.editor.hints.spi.Hint;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.util.NbBundle;


/**
 *
 * @author Jan Lahoda
 */

class ImplementMethodJavaHint extends Hint {
    
    private ClassDefinition       enclosingClass;
    private Collection            methods;
    
    ImplementMethodJavaHint(ClassDefinition enclosingClass, Collection methods) {
        this.enclosingClass = enclosingClass;
        this.methods = methods;
    }

    public String getText() {
        return NbBundle.getBundle(ImplementMethodJavaHint.class).getString("Implement_all_abstract_methods");
    }

    public ChangeInfo implement() {
        boolean fail = true;
        
        JavaModel.getJavaRepository().beginTrans(true);        
        try {
            JavaModel.setClassPath(enclosingClass.getResource());
            List contents=enclosingClass.getContents();
            Iterator i = methods.iterator();
            int index = PositionUtils.getProposedMethodIndex(contents);

            while (i.hasNext()) {
                Method method = (Method)JavaModelUtil.duplicateInScope(enclosingClass,(Method)i.next());
                
                method.setJavadoc(null);
                method.setModifiers(method.getModifiers()&~Modifier.ABSTRACT);
                method.setBodyText("");
                contents.add(index++,method);
            }
            fail = false;
        } finally {
            JavaModel.getJavaRepository().endTrans(fail);
        }
        return null;
    }
    
    public int getType() {
        return ERROR;
    }

}
