/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.hints;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.javacore.api.JavaModel;


/**WARNING: This class is copied from java/editor/src/org/netbeans/modules/editor/java/GeneratorUtils.java
 * on branch completion. This class will eventually be replaced by a fresh copy from the original and
 * once it will be removed completelly and the java editor's version will be used instead.
 *
 * @author Jan Lahoda
 */
public final class GeneratorUtils {
    
    public static final int GETTER = 1;
    public static final int SETTER = 2;
    
    /** Creates a new instance of GeneratorUtils */
    private GeneratorUtils() {
    }
    
    public static String handleImport(Resource rsc, Type type, boolean testOnly) {
        boolean substituteTypeParams = true;
        
        if (type instanceof Array)
            return handleImport(rsc, ((Array)type).getType(), testOnly) + "[]"; // NOI18N
        if (type instanceof TypeParameter && substituteTypeParams)
            return handleImport(rsc, ((TypeParameter)type).getSuperClass(), testOnly);
        if (type instanceof AnnotationType || (type instanceof ParameterizedType && ((ParameterizedType)type).getDefinition() instanceof AnnotationType))
            return "@" + handleImport(rsc, (JavaClass) type, testOnly); // NOI18N
        if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType) type;
            JavaClass definition = p.getDefinition();
            List parameters = p.getParameters();
            StringBuffer result = new StringBuffer();
            
            result.append(handleImport(rsc, definition, testOnly));
            
            if (parameters.size() > 0) {
                result.append('<');
                
                for (Iterator i = parameters.iterator(); i.hasNext(); ) {
                    Type t = (Type) i.next();
                    
                    result.append(handleImport(rsc, t, testOnly));
                    
                    if (i.hasNext()) {
                        result.append(", "); // NOI18N
                    }
                }
                
                result.append('>');
            }
            
            return result.toString();
        }
        if (type instanceof JavaClass) {
            return handleImport(rsc, (JavaClass) type, testOnly);
        }
        return type.getName();
    }
    
    private static String handleImport(Resource rsc, JavaClass clazz, boolean testOnly) {
        if (autoImport(rsc, clazz, false, testOnly)) {
            // TODO - ugly dependency
            return DeclarationInfo.getSimpleName(clazz);
        } else {
            return clazz.getName();
        }
    }
    
    //Copied from NbJavaJMIFastImport:
    private static final int OK = 0;
    private static final int AMBIGUOUS = 1;
    private static final int CLASHING = 2;

    private static int checkImport(JavaClass cls, Resource resource) {
        int status = OK;
        String simpleName = cls.getSimpleName();
        for (Iterator it = resource.getImports().iterator(); it.hasNext();) {
            Import imp = (Import) it.next();
            if (imp.isOnDemand()) {
                if (status == OK) {
                    for (Iterator itt = imp.getImportedElements().iterator(); itt.hasNext();) {
                        NamedElement el = (NamedElement)itt.next();
                        if (el instanceof JavaClass && simpleName.equals(((JavaClass)el).getSimpleName()) && !el.equals(cls)) {
                            status = AMBIGUOUS;
                            break;
                        }
                    }
                }
            } else {
                NamedElement el = imp.getImportedNamespace();
                if (el instanceof JavaClass && simpleName.equals(((JavaClass)el).getSimpleName()) && !el.equals(cls) && !el.getName().equals(cls.getName()))
                    return CLASHING;
            }
        }
        return status;
    }

    private static boolean isClassAlreadyImported(JavaClass cls, Resource resource, int status) {
        if (!cls.isInner()) {
            String pkgName = getPackageName(cls);
            if (("java.lang".equals(pkgName) || resource.getPackageName().equals(pkgName)) && status == OK) //NOI18N
                return true;
            for (Iterator it = resource.getImports().iterator(); it.hasNext();) {
                Import imp = (Import) it.next();
                if (imp.isOnDemand()) {
                    if (imp.getImportedElements().contains(cls) && status == OK)
                        return true;
                }
                
                NamedElement el = imp.getImportedNamespace();
                
                if (el instanceof JavaClass && (el.equals(cls) || el.getName().equals(cls.getName())) && status == OK)
                    return true;
            }
        }
        for (Iterator it = resource.getImports().iterator(); it.hasNext();) {
            Import imp = (Import) it.next();
            if (!imp.isOnDemand() && cls.equals(imp.getImportedNamespace()))
                return true;
        }
        return false;
    }

    private static boolean autoImport(Resource resource, JavaClass cls, boolean pasteFQN, boolean testOnly) {
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            if (resource != null) {
                int status = checkImport(cls, resource);
                if (status == CLASHING) {
                    return false;
                }
                if (!isClassAlreadyImported(cls, resource, status) && !testOnly) {
                    addImport(cls, resource);
                }
            }
            return true;
        } finally {
            JavaModel.getJavaRepository().endTrans(false);
        }
    }

    private static void addImport(NamedElement element, Resource resource) {
        String name = element.getName();
        ListIterator it = resource.getImports().listIterator();
        while (it.hasNext()) {
            Import imp = (Import) it.next();
            String impName = imp.getName();
            if (impName != null && name.compareTo(impName) < 0) {
                it.previous();
                break;
            }
        }
        ImportClass proxy = ((JavaModelPackage)resource.refOutermostPackage()).getImport();
        it.add(proxy.createImport(name, null, false, element instanceof JavaPackage));
    }

    //Copied from JMIUtils:
    private static String getPackageName(ClassDefinition jc) {
        if (jc instanceof UnresolvedClass) {
            String name = jc.getName();
            int index = name.lastIndexOf('.');
            return index < 0 ? "" : name.substring(0, index);
        }
        if (jc instanceof JavaClass) {
            Resource res = jc.getResource();
            if (res != null){
                String result = res.getPackageName();
                if (result != null) {
                    return result;
                }
            }
        }
        return "";
    }

    
}
