/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.hints;

import java.util.List;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.util.NbBundle;

/**
 *
 * @author Tomas Hurka
 */
class CreateParameterJavaHint extends CreateElementJavaHint {
    
    CreateParameterJavaHint(NamedElement symbol) {
        super(symbol);
        hintText=NbBundle.getMessage(CreateParameterJavaHint.class, "MSG_CreateParameter", name);
    }
    
    public ChangeInfo implement() {
        boolean fail = true;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            JavaModel.setClassPath(unresolvedSymbol.getResource());
            Type fieldType=DeclarationInfo.computeType(unresolvedSymbol);
            createParameter(fieldType);
            fail = false;
        } finally {
            JavaModel.getJavaRepository().endTrans(fail);
        }
        return null;
    }

    private Parameter createParameter(Type type) {
        CallableFeature feature = (CallableFeature)JavaModelUtil.getDeclaringFeature(unresolvedSymbol);
        JavaModelPackage pack = (JavaModelPackage)feature.refImmediatePackage();
        TypeReference typeName=JavaModelUtil.resolveImportsForType(feature,type);
        Parameter par = pack.getParameter().createParameter(name,null,false,typeName,0,false);
        List parameters = feature.getParameters();
        int parametersSize = parameters.size();
        Parameter lastParameter = parametersSize > 0 ? (Parameter) parameters.get(parametersSize-1) : null;
        // when method contain vararg parameter, put the newly created
        // parameter before it. Otherwise put it after the last parameter.
        if (lastParameter != null && lastParameter.isVarArg()) {
            parameters.add(parametersSize-1, par);
        } else {
            parameters.add(par);
        }
        return par;
    }   
}
