/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.hints;

import java.util.Collections;
import java.util.List;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.util.NbBundle;

/**
 *
 * @author Tomas Hurka
 */
class CreateLocVarJavaHint extends CreateElementJavaHint {
    
    CreateLocVarJavaHint(NamedElement symbol) {
        super(symbol);
        hintText=NbBundle.getMessage(CreateLocVarJavaHint.class, "MSG_CreateLocalVariable", name);
    }
    
    public ChangeInfo implement() {
        boolean fail = true;
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            JavaModel.setClassPath(unresolvedSymbol.getResource());
            Type fieldType=DeclarationInfo.computeType(unresolvedSymbol);
            createLocalVariable(fieldType);
            fail = false;
        } finally {
            JavaModel.getJavaRepository().endTrans(fail);
        }
        return null;
    }

    private LocalVarDeclaration createLocalVariable(Type type) {
        BehavioralFeature feature=(BehavioralFeature)JavaModelUtil.getDeclaringFeature(unresolvedSymbol);
        JavaModelPackage pack=(JavaModelPackage)feature.refImmediatePackage();
        TypeReference typeName=JavaModelUtil.resolveImportsForType(feature,type);
        LocalVariable var=pack.getLocalVariable().createLocalVariable();
        LocalVarDeclarationClass dp=pack.getLocalVarDeclaration();
        LocalVarDeclaration decl;

        var.setName(name);
        decl=dp.createLocalVarDeclaration(false,typeName,Collections.singletonList(var));
        List/*<Statement>*/ stmts = feature.getBody().getStatements();
        int index = 0;
        // we have to check that there are not super() or this() invocation
        // at the beginning of constructor. In such a case, put the 
        // local variable declaration after constructor invocation.
        if (feature instanceof Constructor &&
            !stmts.isEmpty() && stmts.get(0) instanceof ConstructorInvocation) {
            index = 1;
        }
        stmts.add(index, decl);
        return decl;
    }
    
}
