/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.java.hints;

import java.lang.reflect.Modifier;
import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.editor.hints.spi.Hint;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.filesystems.FileObject;

/**
 *
 * @author Tomas Hurka
 */
abstract class CreateElementJavaHint extends Hint {
    String hintText;
    NamedElement unresolvedSymbol;
    String name;
    
    CreateElementJavaHint(NamedElement symbol) {
        unresolvedSymbol=symbol;
        name=symbol.getName();        
    }
    
    public int getType() {
        return ERROR;
    }
    
    public String getText() {
        assert hintText!=null;
        return hintText;
    }

    void addModified() {
        FileObject fo = JavaModel.getFileObject(unresolvedSymbol.getResource());
        JavaMetamodel.getManager().addModified(fo);
    }
    
    int computeAccessModifiers(ClassDefinition classDefinition, Resource callerResource) {
        int access = 0;
        if (classDefinition instanceof JavaClass && ((JavaClass) classDefinition).isInterface()) {
            return access;
        }
        Resource targetRes = classDefinition.getResource();
        if (callerResource.equals(targetRes)) {
            access = Modifier.PRIVATE;
        } else if (targetRes.getPackageName().equals(callerResource.getPackageName())) {
            access = 0;
        } else {
            access = Modifier.PUBLIC;
        }
        return access;
    }

    int computeStaticModifier(NamedElement unresolvedSymbol) {
        boolean inStaticContext=Modifier.isStatic(JavaModelUtil.getDeclaringFeature(unresolvedSymbol).getModifiers());
        if (unresolvedSymbol instanceof MultipartId) {
            MultipartId mpi=(MultipartId)unresolvedSymbol;
            
            if (mpi.getParent()!=null || inStaticContext)
                return Modifier.STATIC;
        } else if (unresolvedSymbol instanceof VariableAccess) {
            VariableAccess varAcc=(VariableAccess)unresolvedSymbol;
            PrimaryExpression parent=varAcc.getParentClass();
            
            if (parent==null && inStaticContext)
                return Modifier.STATIC;
            if (parent instanceof MultipartId)
                return Modifier.STATIC;
        } else if (unresolvedSymbol instanceof MethodInvocation) {
            MethodInvocation inv=(MethodInvocation)unresolvedSymbol;
            PrimaryExpression parent=inv.getParentClass();
            
            if (parent==null && inStaticContext)
                return Modifier.STATIC;
            if (parent instanceof MultipartId)
                return Modifier.STATIC;
        } else {
            System.err.println("Unknown type "+unresolvedSymbol.getClass()+" name "+unresolvedSymbol.getName());
        }
        return 0;
    }
}
