/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.editor.java;

import java.text.MessageFormat;
import java.util.List;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.Iterator;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.openide.src.Import;
import org.openide.src.Identifier;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.cookies.SourceCookie;
import org.openide.loaders.DataObject;
import org.netbeans.editor.ext.java.JavaFastImport;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCResultItem;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.java.editor.options.JavaOptions;
import org.openide.filesystems.FileObject;

/**
 *
 * @author Miloslav Metelka
 * @version 1.0
 */

public class NbJavaFastImport extends JavaFastImport {
    
    public NbJavaFastImport(JTextComponent target) {
        super(target);
    }
    
    protected JCFinder getFinder() {
        Document doc = Utilities.getDocument(target);
        assert doc != null;
        DataObject dobj = NbEditorUtilities.getDataObject(doc);
        assert dobj != null;
        FileObject fo = dobj.getPrimaryFile();
        return JCFinderFactory.getDefault().getFinder(fo);
    }
    
    protected List findClasses(String exp, int importType) {
        List ret = new ArrayList();
        JCFinder finder = getFinder();
        List classes = finder.findClasses(null, exp, true);
        if (classes != null){
            if (importType == 1){ // package import
                TreeSet ts = new TreeSet();
                for (int i=0; i<classes.size(); i++){
                    JCPackage pkg = finder.getExactPackage(((JCClass)classes.get(i)).getPackageName());
                    if (pkg!=null){
                        ts.add(pkg);
                    }
                }
                Iterator it = ts.iterator();
                while (it.hasNext()) {
                    JCPackage pkg = (JCPackage)it.next();
                    ret.add(new JCResultItem.PackageResultItem(pkg, true));
                }
            }else{
                Iterator it = classes.iterator();
                while (it.hasNext()) {
                    JCClass cls = (JCClass)it.next();
                    ret.add(new JCResultItem.ClassResultItem(cls, true));
                }
            }
        }
        return ret;
    }

    protected void setFastImportSettings(int importType){
        Class kitClass = Utilities.getKitClass(target);
        if (kitClass != null) {
            BaseOptions bop = BaseOptions.getOptions(kitClass);
            if (bop instanceof JavaOptions){
                ((JavaOptions)bop).setFastImportSelection(importType);
            }
        }
    }
    
    protected void updateImport(Object item) {
        if (item instanceof JCResultItem.PackageResultItem || item instanceof JCResultItem.ClassResultItem) {
            Object o = target.getDocument().getProperty(Document.StreamDescriptionProperty);
            if (o instanceof DataObject) {
                DataObject dob = (DataObject)o;
                if (dob != null) {
                    SourceCookie sc = (SourceCookie)dob.getCookie(SourceCookie.class);
                    if (sc != null) {
                        SourceElement se = sc.getSource();
                        if (se != null) {
                            try {
                                if (item instanceof JCResultItem.ClassResultItem){
                                    JCClass cls = (JCClass)((JCResultItem.ClassResultItem)item).getAssociatedObject();
                                    if (isAlreadyImported(cls) || isInTheSamePackage(cls) ){
                                        Utilities.setStatusText(target, 
                                            MessageFormat.format(
                                            org.openide.util.NbBundle.getMessage(NbJavaFastImport.class,"NJFI_CLASS_ALREADY_IMPORTED"), //NOI18N
                                            new Object[] {cls.getFullName()}));
                                    }else{
                                        se.addImport(new Import(Identifier.create(cls.getFullName()), false));                                        
                                    }
                                }else if (item instanceof JCResultItem.PackageResultItem){
                                    String pkgName = ((JCResultItem.PackageResultItem)item).getItemText();
                                    se.addImport(new Import(Identifier.create(pkgName), true));
                                }
                            } catch (SourceException e) {
                            }
                        }
                    }
                }
            }
        }
    }
    
    private boolean isInTheSamePackage(JCClass cls){
        BaseDocument doc = Utilities.getDocument(target);
        if (doc == null) return false;
        NbJavaSyntaxSupport sup = (NbJavaSyntaxSupport)doc.getSyntaxSupport().get(NbJavaSyntaxSupport.class);
        if (sup == null) return false;
        JCClass topClass = sup.getTopClass();
        if (topClass == null) return false;
        String topPkgName = topClass.getPackageName();
        if (topPkgName == null) topPkgName = ""; //NOI18N
        return topPkgName.equals(cls.getPackageName());
    }
}
