/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.editor.java;

import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCResultItem;
import org.netbeans.editor.ext.java.JavaCompletionQuery;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;


/**
 * Java completion query which is aware of project context.
 *
 */
public class NbJavaCompletionQuery extends JavaCompletionQuery {

    protected JCFinder getFinder(){
        BaseDocument bDoc = getBaseDocument();
        if (bDoc!=null){
            SyntaxSupport support = bDoc.getSyntaxSupport();
            if (support!=null){
                NbJavaSyntaxSupport nbSupport = (NbJavaSyntaxSupport)support.get(NbJavaSyntaxSupport.class);
                if (nbSupport!=null){
                    JCFinder finder = nbSupport.getSupportJCFinder();
                    if (finder!=null) return finder;    
                }
            }
        }        
        
        DataObject dobj = NbEditorUtilities.getDataObject(bDoc);
        FileObject fo = dobj.getPrimaryFile();
        return JCFinderFactory.getDefault().getFinder(fo);
    }
    
    protected void initFactory(){
        setJCItemFactory(new NbJCItemFactory());
    }

    public static class NbJCItemFactory implements JavaCompletionQuery.JCItemFactory{
        public NbJCItemFactory(){
            
        }

        public JCResultItem.PackageResultItem createPackageResultItem(JCPackage pkg, boolean displayFullPackagePath){
            return new NbJCResultItem.NbPackageResultItem(pkg, displayFullPackagePath);
        }
        public JCResultItem.ClassResultItem createClassResultItem(JCClass cls, int classDisplayOffset, boolean displayFQN){
            return new NbJCResultItem.NbClassResultItem(cls, classDisplayOffset, displayFQN);
        }
        public JCResultItem.FieldResultItem createFieldResultItem(JCField fld){
            return new NbJCResultItem.NbFieldResultItem(fld);
        }
        public JCResultItem.MethodResultItem createMethodResultItem(JCMethod mtd, JCExpression substituteExp){
            return new NbJCResultItem.NbMethodResultItem(mtd, substituteExp);
        }
        public JCResultItem.ConstructorResultItem createConstructorResultItem(JCConstructor ctr, JCExpression substituteExp){
            return new NbJCResultItem.NbConstructorResultItem(ctr, substituteExp);
        }
        
    }
    

}
