/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.editor.java;

import javax.swing.event.HyperlinkEvent;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.jmi.javamodel.JavaClass;

/**
 *
 * @author Martin Roskanin
 */
public class NbJMIScrollJavaDocPane extends NbScrollJavaDocPane {
    
    /** Creates a new instance of NbJMIScrollJavaDocPane */
    public NbJMIScrollJavaDocPane(ExtEditorUI extEditorUI) {
        super(extEditorUI);
    }

    private CompletionJavaDoc getCJD(){
        return extEditorUI.getCompletionJavaDoc();
    }
    
    protected HyperlinkAction createHyperlinkAction(){
        return new JMIHyperlinkAction();
    }
    
    private class JMIHyperlinkAction extends HyperlinkAction{
        public JMIHyperlinkAction(){
            
        }
        
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e!=null && HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())){
                if (e.getDescription() != null){
                    CompletionJavaDoc cjd = getCJD();
                    if (cjd instanceof NbJMICompletionJavaDoc){
                        NbJMICompletionJavaDoc jmiCJD = (NbJMICompletionJavaDoc)cjd;
                        Object obj = jmiCJD.parseLink(e.getDescription(), (JavaClass) null);
                        if (obj!=null){
                            jmiCJD.setContent(obj);
                            jmiCJD.addToHistory(obj);
                        } else {
                            obj = (e.getURL() == null) ? e.getDescription() : (Object)e.getURL();
                            jmiCJD.setContent(obj);
                        }
                    }else{
                        super.hyperlinkUpdate(e);
                    }
                }
            }
        }
        
    }

}
