/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.editor.java;

import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCConstructor;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JCField;
import org.netbeans.editor.ext.java.JCMethod;
import org.netbeans.editor.ext.java.JCPackage;
import org.netbeans.editor.ext.java.JCPaintComponent;
import org.netbeans.editor.ext.java.JCResultItem;

/**
 *
 * @author  Martin Roskanin
 */
public abstract class NbJCResultItem extends JCResultItem{
    

    
    
    /** Creates a new instance of NbJCResultItem */
    public NbJCResultItem(Object associatedObject) {
        super(associatedObject);
    }
    
    
    public static class NbFieldResultItem extends FieldResultItem{
        
        private JCField fld;
        
        public NbFieldResultItem(JCField fld){
            super(fld);
            this.fld = fld;
        }        

        protected JCPaintComponent.FieldPaintComponent createPaintComponent(){
            return new NbJCPaintComponent.NbFieldPaintComponent();
        }
        
    }
    
    
    public static class NbMethodResultItem extends MethodResultItem{
        
        private JCMethod mtd;
        private JCExpression substituteExp;
        
        public NbMethodResultItem(JCMethod mtd, JCExpression substituteExp){
            super(mtd, substituteExp);
            this.mtd = mtd;
            this.substituteExp = substituteExp;
        }        

        protected JCPaintComponent.ConstructorPaintComponent createPaintComponent(){
            return new NbJCPaintComponent.NbMethodPaintComponent();
        }
        
    }
    
    public static class NbConstructorResultItem extends ConstructorResultItem{
        
        private JCConstructor ctr;
        
        public NbConstructorResultItem(JCConstructor ctr, JCExpression substituteExp){
            super(ctr, substituteExp);
            this.ctr = ctr;
        }

        protected JCPaintComponent.ConstructorPaintComponent createPaintComponent(){
            return new NbJCPaintComponent.NbConstructorPaintComponent();
        }
        
    }
    
    public static class NbPackageResultItem extends PackageResultItem{
        private JCPackage pkg;
        private boolean displayFullPackagePath;
        public NbPackageResultItem(JCPackage pkg, boolean displayFullPackagePath){
            super(pkg, displayFullPackagePath);
            this.pkg = pkg;
            this.displayFullPackagePath = displayFullPackagePath;
        }
        
        protected JCPaintComponent.PackagePaintComponent createPaintComponent(){
            return new NbJCPaintComponent.NbPackagePaintComponent();
        }

    }
    
    public static class NbClassResultItem extends ClassResultItem{
        private JCClass cls;
        private boolean displayFQN;
        public NbClassResultItem(JCClass cls, boolean displayFQN){
            this(cls, 0, displayFQN);
        }
        
        public NbClassResultItem(JCClass cls, int classDisplayOffset, boolean displayFQN){
            super(cls, classDisplayOffset, displayFQN);
            this.cls = cls;
            this.displayFQN = displayFQN;
        }

        protected JCPaintComponent.InterfacePaintComponent createInterfacePaintComponent(){
            return new NbJCPaintComponent.NbInterfacePaintComponent();
        }
        
        protected JCPaintComponent.ClassPaintComponent createClassPaintComponent(){
            return new NbJCPaintComponent.NbClassPaintComponent();
        }
        
    }
}
