/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.editor.java;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;

/**
 *
 * @author Jan Lahoda
 */
public final class GeneratorUtils {
    
    public static final int GETTER = 1;
    public static final int SETTER = 2;
    
    /** Creates a new instance of GeneratorUtils */
    private GeneratorUtils() {
    }
    
    private static String getCapitalizedName(String name) {
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }
    
    private static String[] getGetterSetterNames(Field f, boolean getter) {
        String[] result;
        
        if (getter) {
            Type t = f.getType();
            
            if (t instanceof PrimitiveType && PrimitiveTypeKindEnum.BOOLEAN.equals(((PrimitiveType) t).getKind())) {
                result = new String[2];
                
                result[0] = "is" + getCapitalizedName(f.getName()); // NOI18N
                result[1] = "get" + getCapitalizedName(f.getName()); // NOI18N
            } else {
                result = new String[1];
                
                result[0] = "get" + getCapitalizedName(f.getName()); // NOI18N
            }
        } else {
            result = new String[1];
            
            result[0] = "set" + getCapitalizedName(f.getName()); // NOI18N
        }
        return result;
    }
    
    public static String getGetterSetterName(Field f, boolean getter) {
        return getGetterSetterNames(f, getter)[0];
    }
    
    public static Method createGetterSetter(Field f, boolean getter, int position) {
        ClassDefinition where = f.getDeclaringClass();
        JavaModelPackage pack = (JavaModelPackage) where.refImmediatePackage();
        Method method = pack.getMethod().createMethod();
        boolean isStatic = false;
        TypeReference fieldTypeName = JavaModelUtil.resolveImportsForType(where, f.getType());
        String fieldName = f.getName();
        
        method.setName(getGetterSetterName(f, getter));
        method.setModifiers(Modifier.PUBLIC | (isStatic ? Modifier.STATIC : 0));
        
        if (getter) {
            method.setBodyText("return " + fieldName  +";"); // NOI18N
            method.setTypeName(fieldTypeName);
        } else {
            Parameter param = pack.getParameter().createParameter();
            String    paramName = isStatic ? "a" + getCapitalizedName(fieldName) : fieldName; // NOI18N
            
            param.setTypeName(fieldTypeName);
            param.setName(paramName);
            method.getParameters().add(param);
            if (isStatic) {
                method.setBodyText(fieldName + " = " + paramName + ";"); // NOI18N
            } else {
                method.setBodyText("this." + fieldName + " = " + paramName + ";"); // NOI18N
            }
            method.setType(pack.getPrimitiveType().resolve("void")); // NOI18N
        }
        List features = where.getFeatures();
        if (position == -1) {
            features.add(method);
        } else {
            Feature[] featuresArr = (Feature[])features.toArray(new Feature[0]);
            int afterThis = -1;
            
            for (int cntr = 0; cntr < featuresArr.length; cntr++) {
                if (JavaMetamodel.getManager().getElementPosition(featuresArr[cntr]).getEnd().getOffset() < position) {
                    afterThis = cntr;
                } else {
                    break;
                }
            }
            if (afterThis == -1) {
                features.add(method);
            } else {
                features.add(afterThis + 1, method);
            }
        }
        return method;
    }
    
    public static int checkForGetterSetter(Field f) {
        ClassDefinition where = f.getDeclaringClass();
        String[] getterNames = getGetterSetterNames(f, true);
        String[] setterNames = getGetterSetterNames(f, false);
        boolean getterFound = false;
        boolean setterFound = false;
        List setterPars = Collections.singletonList(f.getType());

        for (int cntr = 0; cntr < getterNames.length; cntr++) {
            if (where.getMethod(getterNames[cntr],Collections.EMPTY_LIST,false) != null) {
                getterFound = true;
                break;
            }
        }

        for (int cntr = 0; cntr < setterNames.length; cntr++) {
            if (where.getMethod(setterNames[cntr],setterPars,false) != null) {
                setterFound = true;
                break;
            }
        }
        
        return (getterFound ? GETTER : 0) | (setterFound ? SETTER : 0);
    }
    
    public static void overrideMethod(ClassDefinition where, Method method, int position) {
        Method newMethod;
        int mods = method.getModifiers();
        List features = where.getContents();
        
        if (method.getResource().getName().endsWith(".class")) {   // method is from class file
            newMethod = (Method)JavaModelUtil.duplicateInScope(where, method);            
        } else {
            Method tempMethod = (Method)method.duplicate();

            tempMethod.setJavadocText(null);
            tempMethod.setBody(null);
            newMethod = (Method)JavaModelUtil.duplicateInScope(where, tempMethod);
            tempMethod.refDelete();
        }
        newMethod.setModifiers(mods & ~(Modifier.NATIVE|Modifier.ABSTRACT|Modifier.SYNCHRONIZED));
        if (position == -1) {
            features.add(newMethod);
        } else {
            ClassMember[] featuresArr = (ClassMember[])features.toArray(new ClassMember[0]);
            int afterThis = -1;
            
            for (int cntr = 0; cntr < featuresArr.length; cntr++) {
                if (JavaMetamodel.getManager().getElementPosition(featuresArr[cntr]).getEnd().getOffset() < position) {
                    afterThis = cntr;
                } else {
                    break;
                }
            }
            if (afterThis == -1) {
                features.add(newMethod);
            } else {
                features.add(afterThis + 1, newMethod);
            }
        }
    }
    
}
