/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor.ext.java;


import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.netbeans.editor.LocaleSupport;

import javax.swing.*;

/**
 * The panel for opening java classes.
 * 
 * @author Miloslav Metelka
 * @version 1.0
 */
class JavaFastOpenPanel extends javax.swing.JPanel {

    private static String CASE_SENSITIVE_SHORTCUT_ACTION = "JFOP_CaseSensitiveShortcutAction"; // NOI18N
    private static String INNER_CLASSES_SHORTCUT_ACTION = "JFOP_InnerClassesShortcutAction"; // NOI18N
    private static String LIBRARY_CLASSES_SHORTCUT_ACTION = "JFOP_LibraryClassesShortcutAction"; // NOI18N

    private JavaFastOpen jfo;
    
    /** Creates new form SaveMacroPanel */
    public JavaFastOpenPanel(JavaFastOpen jfo) {
        this.jfo = jfo;
                    
        initComponents ();
        
        getAccessibleContext().setAccessibleDescription(LocaleSupport.getString ("ACSD_JFO")); // NOI18N
        expField.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFOP_expLabel")); // NOI18N
        expField.setPreferredSize(null);
        final javax.swing.JList jl = jfo.getResultList();
        listScrollPane.setViewportView(jl);
        foundLabel.setLabelFor(jl);
        jl.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFOP_foundLabel")); // NOI18N
        jl.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) { // NOI18N
                    expField.setForeground(jl.getModel().getSize() == 0 ? Color.red : Color.black);
                }
            }
        });

        expLabel.setDisplayedMnemonic (LocaleSupport.getString ("JFOP_expLabelMnemonic", "C").charAt (0)); // NOI18N
        expLabel.setLabelFor(expField);
        expField.addKeyListener(
            new KeyListener() {
                public void keyPressed(KeyEvent evt) {
                    if (!checkArrows(evt))
                        change();
                }
                public void keyReleased(KeyEvent evt) {
                    if (!isArrows(evt))
                        change();
                }
                public void keyTyped(KeyEvent evt) {
                    if (!isArrows(evt))
                        change();
                }
                
                private boolean isArrows(KeyEvent evt) {
                    return JavaFastOpenPanel.this.jfo.boundScrollingKey(evt);
                }
                
                private boolean checkArrows(KeyEvent evt) {
                    if (isArrows(evt)) {
                        JavaFastOpenPanel.this.jfo.delegateScrollingKey(evt);
                        evt.consume();
                        return true;
                    } else {
                        return false;
                    }
               }

                private void change() {
                    JavaFastOpenPanel.this.jfo.postUpdate();
                }
            }
        );
        InputMap im = expField.getInputMap();
        ActionMap am = expField.getActionMap();
        caseSensitive.setMnemonic (LocaleSupport.getString ("JFOP_caseSensitiveBoxMnemonic", "S").charAt (0)); // NOI18N
        caseSensitive.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFOP_caseSensitiveBox")); // NOI18N
        caseSensitive.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JavaFastOpenPanel.this.jfo.postUpdate();
            }
        });
        im.put(KeyStroke.getKeyStroke(caseSensitive.getMnemonic(), InputEvent.ALT_MASK), CASE_SENSITIVE_SHORTCUT_ACTION);
        am.put(CASE_SENSITIVE_SHORTCUT_ACTION, new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                caseSensitive.doClick();
            }
        });

        innerClasses.setMnemonic (LocaleSupport.getString ("JFOP_innerClassesBoxMnemonic", "I").charAt (0)); // NOI18N
        innerClasses.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFOP_innerClassesBox")); // NOI18N
        innerClasses.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JavaFastOpenPanel.this.jfo.postUpdate();
            }
        });
        im.put(KeyStroke.getKeyStroke(innerClasses.getMnemonic(), InputEvent.ALT_MASK), INNER_CLASSES_SHORTCUT_ACTION);
        am.put(INNER_CLASSES_SHORTCUT_ACTION, new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                innerClasses.doClick();
            }
        });

        libraryClasses.setMnemonic (LocaleSupport.getString ("JFOP_libraryClassesBoxMnemonic", "P").charAt (0)); // NOI18N
        libraryClasses.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFOP_libraryClassesBox")); // NOI18N
        libraryClasses.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JavaFastOpenPanel.this.jfo.postUpdate();
            }
        });
        im.put(KeyStroke.getKeyStroke(libraryClasses.getMnemonic(), InputEvent.ALT_MASK), LIBRARY_CLASSES_SHORTCUT_ACTION);
        am.put(LIBRARY_CLASSES_SHORTCUT_ACTION, new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                libraryClasses.doClick();
            }
        });

        foundLabel.setDisplayedMnemonic (LocaleSupport.getString ("JFOP_foundLabelMnemonic", "F").charAt (0)); // NOI18N
        foundLabel.setLabelFor(jfo.getResultList());
    }

    private Dimension getScrollPanePreferredSize(){
        Font scrollPaneFont = listScrollPane.getFont();
        Graphics gr = listScrollPane.getGraphics();
        if (scrollPaneFont != null && gr != null){
            FontMetrics fm = gr.getFontMetrics(scrollPaneFont);
            if (fm!=null){
                return new Dimension(fm.stringWidth("o")*60, fm.getHeight()*12); // NOI18N
            }
        }
        return listScrollPane.getPreferredSize();
    }
    
    public Dimension getPreferredSize() {
        listScrollPane.setPreferredSize (getScrollPanePreferredSize());
        
        Dimension pref = super.getPreferredSize();
        Dimension max = getMaximumSize();
        if( pref.width > max.width ) pref.width = max.width;
        if( pref.height > max.height ) pref.height = max.height;
	return pref;
    }
    
    void popupNotify() {
        expField.requestFocus();
    }
    
    String getSearchText() {
        return expField.getText();
    }
    
    void setSearchText (String text) {
        expField.setText (text);
        expField.selectAll();
    }

    boolean getCaseSensitive() {
        return caseSensitive.isSelected();
    }

    public void setCaseSensitive(boolean value) {
        caseSensitive.setSelected(value);
    }

    boolean getIncludeInnerClasses() {
        return innerClasses.isSelected();
    }

    void setIncludeInnerClasses(boolean value) {
        innerClasses.setSelected(value);
    }

    boolean getIncludeLibraryClasses() {
        return libraryClasses.isSelected();
    }

    void setIncludeLibraryClasses(boolean value) {
        libraryClasses.setSelected(value);
    }

    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        queryPanel = new javax.swing.JPanel();
        expLabel = new javax.swing.JLabel();
        expField = new javax.swing.JTextField();
        listPanel = new javax.swing.JPanel();
        foundLabel = new javax.swing.JLabel();
        listScrollPane = new javax.swing.JScrollPane();
        checkBoxesPanel = new javax.swing.JPanel();
        caseSensitive = new javax.swing.JCheckBox();
        innerClasses = new javax.swing.JCheckBox();
        libraryClasses = new javax.swing.JCheckBox();

        setLayout(new java.awt.BorderLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(12, 12, 0, 11)));
        queryPanel.setLayout(new java.awt.GridBagLayout());

        expLabel.setLabelFor(expField);
        expLabel.setText(LocaleSupport.getString( "JFOP_expLabel", "Class Name:" ));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 0);
        queryPanel.add(expLabel, gridBagConstraints);

        expField.setPreferredSize(new java.awt.Dimension(100, 21));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        queryPanel.add(expField, gridBagConstraints);

        add(queryPanel, java.awt.BorderLayout.NORTH);

        listPanel.setLayout(new java.awt.GridBagLayout());

        listPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(12, 0, 0, 0)));
        foundLabel.setText(LocaleSupport.getString( "JFOP_foundLabel", "Matching Classes:" ));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 2, 0);
        listPanel.add(foundLabel, gridBagConstraints);

        listScrollPane.setPreferredSize(new java.awt.Dimension(200, 100));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        listPanel.add(listScrollPane, gridBagConstraints);

        add(listPanel, java.awt.BorderLayout.CENTER);

        checkBoxesPanel.setLayout(new java.awt.GridBagLayout());

        checkBoxesPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(12, 0, 0, 0)));
        caseSensitive.setText(LocaleSupport.getString("JFOP_caseSensitiveBox", "Case Sensitive"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        checkBoxesPanel.add(caseSensitive, gridBagConstraints);

        innerClasses.setText(LocaleSupport.getString("JFOP_innerClassesBox", "Show Inner Classes"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        checkBoxesPanel.add(innerClasses, gridBagConstraints);

        libraryClasses.setText(LocaleSupport.getString("JFOP_libraryClassesBox", "Show Non-Project Classes"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        checkBoxesPanel.add(libraryClasses, gridBagConstraints);

        add(checkBoxesPanel, java.awt.BorderLayout.SOUTH);

    }//GEN-END:initComponents
    

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox caseSensitive;
    private javax.swing.JPanel checkBoxesPanel;
    private javax.swing.JTextField expField;
    private javax.swing.JLabel expLabel;
    private javax.swing.JLabel foundLabel;
    private javax.swing.JCheckBox innerClasses;
    private javax.swing.JCheckBox libraryClasses;
    private javax.swing.JPanel listPanel;
    private javax.swing.JScrollPane listScrollPane;
    private javax.swing.JPanel queryPanel;
    // End of variables declaration//GEN-END:variables

}
