/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor.ext.java;


import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyChangeListener;

import javax.swing.event.DocumentListener;
import javax.swing.event.DocumentEvent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.ListCellRenderer;
import javax.swing.border.*;
import java.util.*;

import org.netbeans.editor.LocaleSupport;

/**
 * The panel for opening java classes.
 * 
 * @author Miloslav Metelka
 * @version 1.0
 */
final class JavaFastImportPanel extends javax.swing.JPanel {
   
    private JavaFastImport jfi;
    private int currentImportType;
    private int selectedIndex = 0;
    private javax.swing.JList jl;
    
    /** Creates new form SaveMacroPanel */
    public JavaFastImportPanel(JavaFastImport jfi, int importType) {
        this.jfi = jfi;
        this.currentImportType = importType;

        initComponents ();
        
        getAccessibleContext().setAccessibleDescription(LocaleSupport.getString ("ACSD_JFI")); // NOI18N
        listLabel.setDisplayedMnemonic (LocaleSupport.getString ("JFI_listLabelMnemonic", "M").charAt (0)); // NOI18N
        jl = jfi.getResultList();
        listScrollPane.setViewportView(jl);
        listLabel.setLabelFor(jl);
        jl.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFI_listLabel")); // NOI18N

        importClass.setMnemonic(LocaleSupport.getString ("JFI_importButtonMnemonic", "C").charAt (0)); // NOI18N
        importPackage.setMnemonic(LocaleSupport.getString ("JFI_importButton_packageMnemonic", "P").charAt (0)); // NOI18N
        fullyQualifiedName.setMnemonic(LocaleSupport.getString ("JFI_fullyButtonMnemonic", "F").charAt (0)); // NOI18N
        
        importClass.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFI_importClass")); // NOI18N
        importPackage.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFI_importPackage")); // NOI18N
        fullyQualifiedName.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString("ACSD_JFI_fullyQualifiedName")); // NOI18N

//        setMaximumSize( new Dimension( 400, 200 ) );
        Dimension dim = getSize();
        setSize(new Dimension( ((dim.width < 500) ? 500 : dim.width), dim.height));
    }

    public void addNotify () {
        super.addNotify ();
        updateWhenImportTypeChanges (-1);
    }
    
    public int getImportType () {
        if (importPackage.isSelected()) return 1;
       if (fullyQualifiedName.isSelected ()) return 2;
        return 0;
    }

    public void setPackageImportEnabled(boolean b) {
        importPackage.setEnabled(b);
    }

    private void updateWhenImportTypeChanges (int newImportType) {
        selectedIndex = jl.getSelectedIndex();
        if (newImportType == currentImportType) {
            return;
        }
        if (newImportType != -1) {
            currentImportType = newImportType;
        }
        
        // selects the correct radio button
        switch (currentImportType) {
            case 1: importPackage.setSelected (true); break;
            case 2: fullyQualifiedName.setSelected (true); break;
           default: importClass.setSelected (true); break;
        }
        
        
        
        String newText = 
            importPackage.isSelected() 
            ? 
            LocaleSupport.getString("JFI_listLabel_package", "Matching Packages:" ) 
            : 
            LocaleSupport.getString("JFI_listLabel", "Matching Classes:" );

        if (newText.equals (listLabel.getText())) return;
        listLabel.setText (newText);
            
        List result = jfi.evaluate();
        if (result == null || result.size() == 0) { // no data
            return;
        }
        jfi.populate(result);

        jl.setSelectedIndex(selectedIndex);
    }

    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        Dimension max = getMaximumSize();
        if( pref.width > max.width ) pref.width = max.width;
        if( pref.height > max.height ) pref.height = max.height;
	return pref;
    }
    
    void popupNotify() {
        listScrollPane.requestFocus();
    }
    
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        importType = new javax.swing.ButtonGroup();
        listLabel = new javax.swing.JLabel();
        listPanel = new javax.swing.JPanel();
        listScrollPane = new javax.swing.JScrollPane();
        importClass = new javax.swing.JRadioButton();
        importPackage = new javax.swing.JRadioButton();
        fullyQualifiedName = new javax.swing.JRadioButton();

        setLayout(new java.awt.GridBagLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(12, 12, 11, 11)));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(listLabel, gridBagConstraints);

        listPanel.setLayout(new java.awt.GridBagLayout());

        listScrollPane.setPreferredSize(new java.awt.Dimension(320, 80));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        listPanel.add(listScrollPane, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(listPanel, gridBagConstraints);

        importClass.setText(org.openide.util.NbBundle.getBundle(JavaFastImportPanel.class).getString("JFI_importButton"));
        importType.add(importClass);
        importClass.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                updateWhenImportTypeChanges(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(importClass, gridBagConstraints);

        importPackage.setText(org.openide.util.NbBundle.getBundle(JavaFastImportPanel.class).getString("JFI_importButton_package"));
        importType.add(importPackage);
        importPackage.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                updateWhenImportTypeChanges(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(importPackage, gridBagConstraints);

        fullyQualifiedName.setText(org.openide.util.NbBundle.getBundle(JavaFastImportPanel.class).getString("JFI_fullyButton"));
        importType.add(fullyQualifiedName);
        fullyQualifiedName.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                updateWhenImportTypeChanges(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(fullyQualifiedName, gridBagConstraints);

    }//GEN-END:initComponents
    
    private void updateWhenImportTypeChanges(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_updateWhenImportTypeChanges
        // Add your handling code here:
        updateWhenImportTypeChanges (getImportType ());
    }//GEN-LAST:event_updateWhenImportTypeChanges

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JRadioButton importPackage;
    private javax.swing.JPanel listPanel;
    private javax.swing.ButtonGroup importType;
    private javax.swing.JLabel listLabel;
    private javax.swing.JRadioButton importClass;
    private javax.swing.JRadioButton fullyQualifiedName;
    private javax.swing.JScrollPane listScrollPane;
    // End of variables declaration//GEN-END:variables

}
