/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.editor.ext.java;

import java.util.Iterator;

/**
* Java completion class provider
* (For more functionality use JCClassProvider2.)
*
* @author Miloslav Metelka
* @version 1.00
*/

public interface JCClassProvider {

    public Iterator getClasses();

    /**
    * @return true when append was successful
    *   or false when it failed or was broken
    *   by added classprovider.
    */
    public boolean append(JCClassProvider cp);

    public void reset();

    /** This method is executed by the target Class Provider
    * to notify this provider about the class appending.
    * @param c JC class that was appended
    * @return true to continue building, false to stop build
    */
    public boolean notifyAppend(JCClass c, boolean appendFinished);

}
