/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

/*
 * EarConfigBeanPanel.java
 *
 * Created on March 21, 2003, 1:22 PM
 */

package org.netbeans.tests.j2eeserver.plugin.jsr88.ui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import org.netbeans.tests.j2eeserver.plugin.jsr88.EarConfigBean;

/**
 *
 * @author  Jeri Lockhart
 */
public class EarConfigBeanPanel extends javax.swing.JPanel implements PropertyChangeListener {
    EarConfigBean bean = null;

    /** Creates new form EarConfigBeanPanel */
    public EarConfigBeanPanel(DConfigBean bean) {
        this.bean = (EarConfigBean)bean;
        initComponents();
        initComponentsMore();
    }

    private void initComponentsMore() {
        secLevTxt.setText(bean.getSecurityLevel());
        sessParamTxt.setText(bean.getSessionParam());
        bean.addPropertyChangeListener(this);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        secLevTxt = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        sessParamTxt = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Security Level:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(11, 11, 0, 0);
        add(jLabel1, gridBagConstraints);

        secLevTxt.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                secLevTxtActionPerformed(evt);
            }
        });

        secLevTxt.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                secLevTxtFocusLost(evt);
            }
        });

        secLevTxt.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                secLevTxtKeyTyped(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new java.awt.Insets(11, 11, 0, 11);
        add(secLevTxt, gridBagConstraints);

        jLabel2.setText("Session Param:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(11, 11, 11, 0);
        add(jLabel2, gridBagConstraints);

        sessParamTxt.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sessParamTxtActionPerformed(evt);
            }
        });

        sessParamTxt.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                sessParamTxtFocusLost(evt);
            }
        });

        sessParamTxt.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                sessParamTxtKeyTyped(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new java.awt.Insets(11, 11, 11, 11);
        add(sessParamTxt, gridBagConstraints);

    }//GEN-END:initComponents

    private void sessParamTxtKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_sessParamTxtKeyTyped
         if (bean.getSessionParam() == null || !bean.getSessionParam().trim().equals(sessParamTxt.getText().trim())) {
            bean.setSessionParam(sessParamTxt.getText().trim());
            System.out.println("sessParamTxtFocusLost property changed.");
        }
    }//GEN-LAST:event_sessParamTxtKeyTyped

    private void secLevTxtKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_secLevTxtKeyTyped
         if (bean.getSecurityLevel() == null || !bean.getSecurityLevel().trim().equals(secLevTxt.getText().trim())) {
            bean.setSecurityLevel(secLevTxt.getText().trim());
            System.out.println("secLevTxtFocusLost  property changed.");
        }
    }//GEN-LAST:event_secLevTxtKeyTyped

    private void sessParamTxtFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_sessParamTxtFocusLost
       if (bean.getSessionParam() == null || !bean.getSessionParam().trim().equals(sessParamTxt.getText().trim())) {
            bean.setSessionParam(sessParamTxt.getText().trim());
            System.out.println("sessParamTxtFocusLost property changed.");
        }
    }//GEN-LAST:event_sessParamTxtFocusLost

    private void secLevTxtFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_secLevTxtFocusLost
        if (bean.getSecurityLevel() == null || !bean.getSecurityLevel().trim().equals(secLevTxt.getText().trim())) {
            bean.setSecurityLevel(secLevTxt.getText().trim());
            System.out.println("secLevTxtFocusLost  property changed.");
        }
    }//GEN-LAST:event_secLevTxtFocusLost

    private void sessParamTxtActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sessParamTxtActionPerformed
       System.out.println("sessParamTxtactionPerformed ");
        bean.setSessionParam(sessParamTxt.getText().trim());
    }//GEN-LAST:event_sessParamTxtActionPerformed

    private void secLevTxtActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_secLevTxtActionPerformed
        System.out.println("secLevTxtActionPerformed ");
        bean.setSecurityLevel(secLevTxt.getText().trim());
    }//GEN-LAST:event_secLevTxtActionPerformed

    /** This method gets called when a bound property is changed.
     * @param evt A PropertyChangeEvent object describing the event source
     *   	and the property that has changed.
     *
     */
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("sessionParam")) {
            sessParamTxt.setText((String)evt.getNewValue());
        }
        else if (evt.getPropertyName().equals("securityLevel")) {
            secLevTxt.setText((String)evt.getNewValue());
        }
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JTextField secLevTxt;
    private javax.swing.JTextField sessParamTxt;
    // End of variables declaration//GEN-END:variables

}
