/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.tests.j2eeserver.plugin.jsr88;

import javax.enterprise.deploy.spi.exceptions.*;
import javax.enterprise.deploy.spi.*;
import java.beans.*;
import javax.enterprise.deploy.model.*;

import java.util.*;

/**
 *
 * @author  gfink
 */
public class EjbConfigBean implements DConfigBean {
    
    DDBean bean;
    EjbModuleConfigBean module;
    DepConfig config;
    Collection children = new HashSet();
    String EJBREF = "ejb-ref";
    String EJBLOCALREF = "ejb-local-ref";
    String RESOURCEREF = "resource-ref";
    
    public EjbConfigBean(DDBean bean, EjbModuleConfigBean module, DepConfig config) {
        this.bean = bean; this.config = config; this.module = module;
        this.ejbName = bean.getChildBean("ejb-name")[0].getText();
    }
      
    public DConfigBean getDConfigBean(DDBean dDBean) throws ConfigurationException {
        DConfigBean ret = null;
        if(dDBean.getXpath().endsWith(EJBREF) || dDBean.getXpath().endsWith(EJBLOCALREF))
            ret = new EjbRefConfigBean(dDBean, config);
        else if (dDBean.getXpath().endsWith(RESOURCEREF))
            ret = new ResourceRefConfigBean(dDBean, module, config);
        if(ret != null) children.add(ret);
        return ret;
    }
    
    public DDBean getDDBean() {
        return bean;
    }
    
    public String[] getXpaths() {
        return new String[] { EJBREF, EJBLOCALREF, RESOURCEREF };
    }
    
    public void notifyDDChange(XpathEvent xpathEvent) {
    }
    
    public void removeDConfigBean(DConfigBean dConfigBean) throws BeanNotFoundException {
        children.remove(dConfigBean);
        propertyChangeSupport.firePropertyChange(dConfigBean.getClass().toString(),dConfigBean,null);
    }
    
      /** Utility field used by bound properties. */
      private PropertyChangeSupport propertyChangeSupport =  new PropertyChangeSupport(this);
      
      /** Holds value of property jndiName. */
      private String jndiName;
      
      /** Holds value of property configurationName. */
      private String configurationName;
      
      /** Holds value of property securityProxy. */
      private String securityProxy;
      
      /** Holds value of property ejbName. */
      private String ejbName;
      
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        propertyChangeSupport.addPropertyChangeListener(listener);
    }
    
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        propertyChangeSupport.removePropertyChangeListener(listener);
    }   
    
    /** Getter for property jndiName.
     * @return Value of property jndiName.
     */
    public String getJndiName() {
        return this.jndiName;
    }
    
    /** Setter for property jndiName.
     * @param jndiName New value of property jndiName.
     */
    public void setJndiName(String jndiName) {
        String oldJndiName = this.jndiName;
        this.jndiName = jndiName;
        propertyChangeSupport.firePropertyChange("jndiName", oldJndiName, jndiName);
    }
    
    /** Getter for property configurationName.
     * @return Value of property configurationName.
     */
    public String getConfigurationName() {
        return this.configurationName;
    }
    
    /** Setter for property configurationName.
     * @param configurationName New value of property configurationName.
     */
    public void setConfigurationName(String configurationName) {
        String oldConfigurationName = this.configurationName;
        this.configurationName = configurationName;
        propertyChangeSupport.firePropertyChange("configurationName", oldConfigurationName, configurationName);
    }
    
    /** Getter for property securityProxy.
     * @return Value of property securityProxy.
     */
    public String getSecurityProxy() {
        return this.securityProxy;
    }
    
    /** Setter for property securityProxy.
     * @param securityProxy New value of property securityProxy.
     */
    public void setSecurityProxy(String securityProxy) {
        String oldSecurityProxy = this.securityProxy;
        this.securityProxy = securityProxy;
        propertyChangeSupport.firePropertyChange("securityProxy", oldSecurityProxy, securityProxy);
    }
    
    /** Getter for property ejbName.
     * @return Value of property ejbName.
     */
    public String getEjbName() {
        return this.ejbName;
    }
    
}
