/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.deployment.plugins.api;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

/**
 * This interface represents a "provider" for the Ant deployment.
 * <p>
 * The j2eeserver uses {@link OptionalDeploymentManagerFactory} to optains an 
 * instance of the AntDeploymentProvider from the server integration plugin.
 *
 * @author sherold
 *
 * @since 1.18
 */
public interface AntDeploymentProvider {
    
    /**
     * Generates the Ant deployment build script for the given module type to 
     * the specified output stream.
     * <p>
     * See {@link org.netbeans.modules.j2ee.deployment.devmodules.api.AntDeploymentHelper#writeDeploymentScript(File,Object,String)}
     * for what targets and properties is the Ant deployment build script required 
     * to define and what predefined properties it might use.
     *
     * @param os the output stream the deployment build script should be generated 
     *           to.
     * @param moduleType the module type the build script should handle. Use the
     *                   constants defined in the {@link J2eeModule}.
     * @throws IOException if a problem during generating the build script occurs.
     */
    void writeDeploymentScript(OutputStream os, Object moduleType) throws IOException;
    
    /**
     * Return the server instance specific deployment properties file used by 
     * the deployment build script generated by the {@link #writeDeploymentScript(OutputStream,Object)}.
     *
     * @return the deployment properties file.
     */
    File getDeploymentPropertiesFile();
}
