/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification.ws.checks;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.ProblemFinder;
import org.netbeans.modules.j2ee.verification.ProblemFindingUtils;
import org.openide.util.NbBundle;

/**
 *
 * @author Tomasz Slota
 */
public class AttributeNotAllowedOnInterfaces extends ProblemFinder {
    
    private static final Collection attrsNotAllowedOnInterfaces = new TreeSet(Arrays.asList(new String[]{
        "serviceName", "endpointInterface" //NOI18N
    }));

    public void parseDocument() {
        JavaClass javaClass = getMainJavaClass();
        
        if (!javaClass.isInterface()){
            return;
        }
        
        Annotation wsAnnotation = ProblemFindingUtils.findAnnotation(javaClass, WSAnnotations.WEB_SERVICE);
        
        if (wsAnnotation != null){
            for (Iterator it = wsAnnotation.getAttributeValues().iterator(); it.hasNext();){
                AttributeValue attValue = (AttributeValue) it.next();
                String attrName = attValue.getName();
                
                /* attrName will be null for the default attribute ('name')
                 * e.g.  @WebService("name"). 
                 * We may ignore it.
                 * See #
                 */   
                if (attrName != null 
                        && attrsNotAllowedOnInterfaces.contains(attrName)){ 
                    
                    JEEVerificationContextInfo problemContext = new JEEVerificationContextInfo(javaClass);
                    problemContext.setElement(attValue);
                    
                    JEEVerificationProblemMark problemMark = new JEEVerificationProblemMark("ws_attr_not_allowed_on_intefaces", //NOI18N
                        NbBundle.getMessage(this.getClass(), "MSG_AttributeNotAllowedOnIntefaces", attrName),
                        problemContext);
                    
                    attachProblemMarkToElement(problemMark, attValue);
                    addProblemMark(problemMark);
                }
            }
        }
    }
    
}
