/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.rules.method;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.BeanAccessType;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIProblemFinder;
import org.netbeans.modules.j2ee.verification.persistence.predicates.member.NotAnnotatedPred;
import org.netbeans.modules.j2ee.verification.persistence.predicates.method.GetterPred;

import java.util.Arrays;

/**
 * An entity must follow consistent access type, i.e. either fields are
 * annotated or properties are annotated, but not both. So, this rule goes like
 * this: If class has property access type, only then getter is annotated.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class ConsistentFieldAccessType extends AbstractRule {

    public ConsistentFieldAccessType() {
        super(new NotAnnotatedPred(),
                Arrays.asList(new GetterPred()));
    }

    public String getId() {
        return PersistenceAPIProblemFinder.RuleNames.ConsistentFieldAccessType;
    }

    protected String getMessageKey() {
        return "MSG_InconsistentFieldAccessType"; // NOI18N
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        return (ctx.isEmbeddable() || ctx.isIsEntityClass() ||
                ctx.isMappedSuperclass()) &&
                (ctx.getBeanAccessType() == BeanAccessType.FIELD) &&
                super.isApplicable(subject, ctx);
    }
}
