/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.rules.field;

import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.common.predicates.member.NonPublicMemberPred;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIProblemFinder;
import org.netbeans.modules.j2ee.verification.persistence.predicates.field.PersistentFieldPred;
import org.netbeans.jmi.javamodel.Element;

import java.util.Arrays;

/**
 * Java Persistence API version 1.0 has this restriction in section #2.1 that
 * instance variables must be private, protected or package visibility.
 * <p/>
 * This is not applicable to transient fields.
 * <p/>
 * This rule is there to avoid direct access to persistence state of an entity.
 * Not allowing public visibility to instance state goes a long way to achive
 * this, although not completely avoid it.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class NonPublicPersistentField extends AbstractRule {

    public NonPublicPersistentField() {
        super(new NonPublicMemberPred(),
                Arrays.asList(new PersistentFieldPred()));
    }

    public String getId() {
        return PersistenceAPIProblemFinder.RuleNames.NonPublicPersistentField;
    }

    protected String getMessageKey() {
        return "MSG_PublicPersistentField"; // NOI18N
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        return (ctx.isEmbeddable() || ctx.isIsEntityClass() ||
                ctx.isMappedSuperclass()) &&
                super.isApplicable(subject, ctx);
    }
}
