/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.verification.persistence.rules.field;

import java.util.Arrays;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.common.predicates.member.IsMultiValuedEntityTypePred;
import org.netbeans.modules.j2ee.verification.persistence.BeanAccessType;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIProblemFinder;
import org.netbeans.modules.j2ee.verification.persistence.predicates.field.PersistentFieldPred;
import org.netbeans.modules.j2ee.verification.persistence.predicates.member.NotMultiValuedRelationshipPred;

/**
 *
 * @author Tomasz.Slota@Sun.COM
 */
public class MVRelationshipDefinedForField  extends AbstractRule {
    
    /** Creates a new instance of EntityRelationDefined */
    public MVRelationshipDefinedForField() {
        super(new IsMultiValuedEntityTypePred(), Arrays.asList(new NotMultiValuedRelationshipPred(), new PersistentFieldPred()));
    }
    
    protected String getMessageKey() {
        return "MSG_MVEntityRelationNotDefined"; //NOI18N
    }
    
    public String getId() {
        return PersistenceAPIProblemFinder.RuleNames.MVEntityRelationDefined;
    }
    
    @Override protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        return ctx.getBeanAccessType() == BeanAccessType.FIELD && super.isApplicable(subject, ctx);
    }
    
    @Override public JEEVerificationProblemMark.Severity getSeverity(){
        return JEEVerificationProblemMark.Severity.WARNING;
    }
}
