/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.rules.annotation;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIProblemFinder;
import org.netbeans.modules.j2ee.verification.persistence.predicates.annotation.EmbeddedOrEmbeddedIdPred;
import org.netbeans.modules.j2ee.verification.persistence.predicates.clazz.AnnotatedAsEmbeddablePred;

import javax.jmi.reflect.RefFeatured;
import java.util.Arrays;

/**
 * When a field or property is annotated as @Embedded, then correpsonding type
 * must be annotated as Embeddable
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class EmbeddedTargetIsEmbeddable extends AbstractRule {

    public EmbeddedTargetIsEmbeddable() {
        super(null, Arrays.asList(new EmbeddedOrEmbeddedIdPred()));
    }

    protected String getMessageKey() {
        return "MSG_EmbeddedTargetIsEmbeddable"; // NOI18N
    }

    public String getId() {
        return PersistenceAPIProblemFinder.RuleNames.EmbeddedTargetIsEmbeddable;
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        return (ctx.isIsEntityClass() || ctx.isMappedSuperclass()) &&
                super.isApplicable(subject, ctx);
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            Annotation annotation = Annotation.class.cast(subject);
            Type targetType = null;
            final RefFeatured obj = annotation.refImmediateComposite();
            if (obj instanceof Field) {
                targetType = Field.class.cast(obj).getType();
            } else if (obj instanceof Method) {
                targetType = Method.class.cast(obj).getType();
            }
            if (targetType instanceof JavaClass) {
                if (!new AnnotatedAsEmbeddablePred().evaluate(targetType)) {
                    return createProblem(ctx, subject);
                }
            }
        }
        return null;
    }
}
