/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.rules.annotation;

import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.common.predicates.clazz.NonAbstractClassPred;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIProblemFinder;
import org.netbeans.modules.j2ee.verification.persistence.predicates.annotation.DiscriminatorValuePred;
import org.netbeans.modules.j2ee.verification.persistence.predicates.clazz.AnnotatedAsEntityPred;

import javax.jmi.reflect.RefFeatured;
import java.util.Arrays;

/**
 * DiscriminatorValue annotation can only be specified for concrete entity.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class DiscriminatorValueOnConcreteEntity extends AbstractRule {

    public DiscriminatorValueOnConcreteEntity() {
        super(null, Arrays.asList(new DiscriminatorValuePred()));
    }

    protected String getMessageKey() {
        return "MSG_DiscriminatorValueOnConcreteEntity"; // NOI18N
    }

    public String getId() {
        return PersistenceAPIProblemFinder.RuleNames.DiscriminatorValueOnConcreteEntity;
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        return (ctx.isIsEntityClass()) &&
                super.isApplicable(subject, ctx);
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            Annotation annotation = Annotation.class.cast(subject);
            final RefFeatured obj = annotation.refImmediateComposite();
            if (obj instanceof JavaClass) {
                JavaClass jc = JavaClass.class.cast(obj);
                if (!new AnnotatedAsEntityPred().evaluate(jc) ||
                        !new NonAbstractClassPred().evaluate(jc)) {
                    return createProblem(ctx, subject);
                }
            }
        }
        return null;
    }

}
