/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.predicates.member;

import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.modules.j2ee.verification.common.predicates.member.AbstractPredicate;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper;

import java.util.List;

import static org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIAnnotations.*;

/**
 * Is this field annotated with any annotation that makes it a persistent field
 * or property? Any annottaion other than Transient makes a member persistent.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class AnnotatedAsPersistentPred extends AbstractPredicate {
    protected boolean evaluate(ClassMember member) {
        // the cast is intentionally done.
        for (Annotation a : (List<Annotation>) member.getAnnotations()) {
            if (PersistenceAPIHelper.isJSR220FieldOrPropertyAccessAnnotation(a)
                    &&
                    !a.getType().getName().equals(TRANSIENT)) {
                return true;
            }
        }
        return false;
    }
}
