/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.predicates.clazz;

import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.verification.common.predicates.clazz.AbstractPredicate;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper;
import static org.netbeans.modules.j2ee.verification.ProblemFindingUtils.findAnnotation;
import static org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIAnnotations.ENTITY;

/**
 * Is this the root entity class? i.e. it must be the top most entity class
 * in entity hierarchy
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class RootEntityPred extends AbstractPredicate {

    protected boolean evaluate(JavaClass javaClass) {
        if(findAnnotation(javaClass, ENTITY) != null) {
            return PersistenceAPIHelper.findEntityRootClass(javaClass) == javaClass;
        }
        return false;
    }

}
