/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.persistence.predicates.annotation;

import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.BooleanLiteral;
import org.netbeans.modules.j2ee.verification.common.predicates.annotation.AbstractPredicate;

import java.util.List;

import static org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIAnnotations.NULLABLE;
import static org.netbeans.modules.j2ee.verification.JEEVerificationAnnotationProvider.tmpDbg;

/**
 * Is nullable specified in @Column? If so, is it set to true?
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class ColumnHasNullableSetToTruePred extends AbstractPredicate {

    protected boolean evaluate(Annotation annotation) {
        boolean result = false;
        for (AttributeValue attr :
                (List<AttributeValue>) annotation.getAttributeValues()) {
            if (NULLABLE.equals(attr.getName())) { // nullable is explicitly specified
                final org.netbeans.jmi.javamodel.InitialValue value = attr.getValue();
                tmpDbg("nullable=" + value + " and isValid = " +  value.isValid()); // NOI18N
                try {
                    result = BooleanLiteral.class.cast(value).isValue();
                } catch(ClassCastException cce) {
                    // this happens when user says nullable=neither-true-nor-false
                }
                break;
            }
        }
        tmpDbg("ColumnHasNullableSetToTruePred returns " + result); // NOI18N
        return result;
    }

}
