/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification.persistence.hints;

import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationHint;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.util.NbBundle;

/**
 *
 * @author Tomasz Slota
 */
public class UnifyFieldAccessHint extends JEEVerificationHint {
    
    private String text;
    
    /** Creates a new instance of RemoveAccessTypeInconsistencyHint */
    public UnifyFieldAccessHint(JEEVerificationContextInfo problemContext) {
        super(problemContext);
        text = NbBundle.getMessage(this.getClass(), "MSG_UnifyFieldAccessHint");
    }

    public String getText() {
        return text;
    }

    public ChangeInfo implement() {
        JavaClass javaClass = getProblemContext().getJavaClass();
        
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            JavaModel.setClassPath(javaClass.getResource());
            
            Element classElements[] = (Element[])javaClass.getContents().toArray(new Element[]{});
        
            for (int i = 0; i < classElements.length; i++) {
                if (classElements[i] instanceof Method){
                    Method method = (Method) classElements[i];
                    
                    Annotation[] annots = (Annotation[]) method.getAnnotations().toArray(new Annotation[0]);
                    for (int j = 0; j < annots.length; j ++){
                        if (PersistenceAPIHelper.isJSR220FieldOrPropertyAccessAnnotation(annots[j])){
                            // find corresponding field name
                            String fieldName = PersistenceAPIHelper.getFieldNameFromAccessorName(method.getName());
                            Field targetField = javaClass.getField(fieldName, false);
                            
                            method.getAnnotations().remove(annots[j]);
                            targetField.getAnnotations().add(annots[j]);
                        }
                    }
                }
            }
            
        } finally {
            JavaModel.getJavaRepository().endTrans(false);
        }
        return null;
    }

    public int getType() {
        return ERROR;
    }
    
}
