/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification.persistence.hints;

import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationHint;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/**
 *
 * @author Tomasz Slota
 */
public class EncapsulateFieldHint extends JEEVerificationHint {
    private String text;
    
    /** Creates a new instance of EncapsulateFieldHint */
    public EncapsulateFieldHint(JEEVerificationContextInfo problemContext) {
        super(problemContext);
        text = NbBundle.getMessage(this.getClass(), "MSG_EncapsulateField");
    }

    public String getText() {
        return text;
    }

    public ChangeInfo implement() {
        InstanceContent ic = new InstanceContent();
        ic.add(getProblemContext().getField());
        Node node = SourceNodes.getExplorerFactory().createClassNode(getProblemContext().getJavaClass());
        ic.add(node);
        
        Lookup actionContext = new AbstractLookup(ic);
        final Action encapsuleteAction = RefactoringActionsFactory.encapsulateFieldsAction().createContextAwareInstance(actionContext);
        
        SwingUtilities.invokeLater(new Runnable(){
            public void run() {
                encapsuleteAction.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
            }
        });
        
        return null;
    }

    public int getType() {
        return ERROR;
    }
    
}
