/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 *
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification.persistence.hints;

import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationHint;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.util.NbBundle;

/**
 *
 * @author Tomasz Slota
 */
public class CreatePersistenceUnitHint extends JEEVerificationHint {
    
    /** Creates a new instance of CreatePersistenceUnitHint */
    public CreatePersistenceUnitHint(JEEVerificationContextInfo problemContext) {
        super(problemContext);
    }
    
    public String getText() {
        return NbBundle.getMessage(this.getClass(), "LBL_CreatePersistenceUnitHint");
    }
    
    public ChangeInfo implement() {
        final Project project = FileOwnerQuery.getOwner(JavaModel.getFileObject(getProblemContext().getJavaClass().getResource()));
        
        SwingUtilities.invokeLater(new Runnable(){
            public void run() {
                Util.createPersistenceUnitUsingWizard(project);
            }
        });
        
        return null;
    }
    
    public int getType() {
        return ERROR;
    }
    
}
