/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.verification.persistence.hints;

import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.TypedElement;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;

/**
 *
 * @author Tomasz.Slota@Sun.COM
 */
public abstract class CreateMVRelationshipAbstractHint extends CreateRelationshipAbstractHint {
    public CreateMVRelationshipAbstractHint(JEEVerificationContextInfo problemContext,
            String annotationClass, String complimentaryAnnotationClassName){
        super(problemContext, annotationClass, complimentaryAnnotationClassName);
    }
    
    @Override protected JavaClass getTargetEntityClass() {
        JavaClass targetClass = null;
        
        TypedElement e = (TypedElement) getProblemContext().getElement();
        JavaClass elementClass = (JavaClass)e.getType();
        
        if (elementClass instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)elementClass;
            
            if (pt.getParameters().size() == 1){
                targetClass = (JavaClass) pt.getParameters().get(0);
                
                while (targetClass instanceof ParameterizedType) {
                    targetClass = ((ParameterizedType)targetClass).getDefinition();
                }
            }
        }
        
        return targetClass;
    }
}
