/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification.persistence.hints;

import java.awt.Dialog;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.verification.*;
import org.netbeans.modules.j2ee.verification.persistence.BeanAccessType;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/**
 *
 * @author Tomasz Slota
 */
public class CreateIdAnnotationHint extends JEEVerificationHint {
    /** Creates a new instance of MissingIDHint */
    public CreateIdAnnotationHint(JEEVerificationContextInfo problemContext) {
        super(problemContext);
    }

    public String getText() {
        return NbBundle.getMessage(CreateIdAnnotationHint.class, "MSG_MissingIDAnnotationHint");
    }

    public ChangeInfo implement() {
        PickOrCreateFieldPanel pnlPickOrCreateField = new PickOrCreateFieldPanel();
        pnlPickOrCreateField.setAvailableFields(getAvailableFields());
        
        DialogDescriptor ddesc = new DialogDescriptor(pnlPickOrCreateField,
                NbBundle.getMessage(CreateIdAnnotationHint.class, "LBL_AddIDAnnotationDlgTitle"));
                
        Dialog dlg = DialogDisplayer.getDefault().createDialog(ddesc);
       
        pnlPickOrCreateField.setDlgDescriptor(ddesc);
        dlg.setLocationRelativeTo(null);
        dlg.setVisible(true);
        
        if (ddesc.getValue() == DialogDescriptor.OK_OPTION){
            if (pnlPickOrCreateField.wasCreateNewFieldSelected()){
                createIDField(pnlPickOrCreateField.getNewIdName(), pnlPickOrCreateField.getSelectedIdType());
            }
            else{
                // pick existing
                FieldWrapper fw = (FieldWrapper) pnlPickOrCreateField.getSelectedField();
                createIDField(fw.getField().getName(), null);
            }
        }
        
        return null;
    }
    
    private Object[] getAvailableFields(){
        ArrayList fields = new ArrayList();
        
        JavaModel.getJavaRepository().beginTrans(false);
        
        try{
            JavaModel.setClassPath(getProblemContext().getJavaClass().getResource());
            
            for (Iterator i = getProblemContext().getJavaClass().getContents().iterator(); i.hasNext();){
                Object o = i.next();
                
                if (o instanceof Field){
                    Field f = (Field) o;
                    fields.add(new FieldWrapper(f));
                }
            }
        }
        finally{
            JavaModel.getJavaRepository().endTrans(false);
        }
        
        
        return fields.toArray();
    }

    private void createIDField(String fieldName, String fieldType) {
        assert fieldName != null && fieldName.length() > 0;
        JavaClass javaClass = getProblemContext().getJavaClass();
        
        JavaModel.getJavaRepository().beginTrans(true);
        try {    
            JavaModel.setClassPath(javaClass.getResource());
            
            // create id field
            
            Field idField = null;
            idField = javaClass.getField(fieldName, false); //TODO: can super class fields cannot be used
            
            if (idField == null){
                idField = JMIGenerationUtil.createField(javaClass, fieldName, Modifier.PRIVATE, fieldType);
                javaClass.getFeatures().add(0,idField);
            }
            
            if (PersistenceAPIHelper.findBeanAccessType(javaClass) == BeanAccessType.PROPERTY){
                String idType = idField.getTypeName().getName();
                
                // create getter
                
                Method getter = createMethodIfNeeded(javaClass, PersistenceAPIHelper.getAccessorName(fieldName), idType, Collections.EMPTY_LIST); //NOI18N
                getter.setBodyText("return " + fieldName + ";"); //NOI18N
                Annotation idAnnotation = JMIGenerationUtil.createAnnotation(javaClass, "javax.persistence.Id", Collections.EMPTY_LIST); //NOI18N
                getter.getAnnotations().add(idAnnotation);
                
                
                // create setter
                
                List setterArg = Collections.singletonList(idField.getType());
                String getterName = PersistenceAPIHelper.getMutatorName(fieldName);
                
                if (javaClass.getMethod(getterName, setterArg, false) == null){
                    Method setter = createMethodIfNeeded(javaClass, getterName, "void", setterArg); //NOI18N
                    Parameter idParameter = JMIGenerationUtil.createParameter(javaClass, fieldName, idType);
                    setter.getParameters().add(idParameter);
                    setter.setBodyText("this." + fieldName + " = " + fieldName + ";"); //NOI18N
                }
            } else{ // assuming field access
                Annotation idAnnotation = JMIGenerationUtil.createAnnotation(idField, "javax.persistence.Id", Collections.EMPTY_LIST); //NOI18N
                idField.getAnnotations().add(idAnnotation);
            }
        } finally {
            JavaModel.getJavaRepository().endTrans(false);
        }
    }
    
    private static Method createMethodIfNeeded(JavaClass parentClass, String methodName, String returnType, List args){
        Method method = parentClass.getMethod(methodName, args, false);
        
        if (method == null){
            method = JMIGenerationUtil.createMethod(parentClass, methodName, Modifier.PUBLIC, returnType);
            parentClass.getFeatures().add(method);
        }
        
        return method;
    }

    public int getType() {
        return ERROR;
    }
    
    private class FieldWrapper{
        private Field field;
        
        FieldWrapper(Field field)
        {
            this.field = field;
        }
        
        Field getField(){
            return field;
        }
        
        public String toString(){
            return field.getTypeName().getName() + "   " + field.getName();
        }
    }
}
