/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification.persistence.hints;

import java.lang.reflect.Modifier;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationHint;
import org.openide.util.NbBundle;

/**
 *
 * @author Tomasz Slota
 */
public class CreateDefaultConstructor extends JEEVerificationHint {
    
    /** Creates a new instance of CreateDefaultConstructor */
    public CreateDefaultConstructor(JEEVerificationContextInfo problemContext) {
        super(problemContext);
    }

    public String getText() {
        return NbBundle.getMessage(this.getClass(), "LBL_CreateDefaultConstructor");
    }

    public ChangeInfo implement() {
        JavaClass javaClass = getProblemContext().getJavaClass();
        Constructor constructor = JMIGenerationUtil.createConstructor(javaClass, Modifier.PUBLIC);
        javaClass.getFeatures().add(0, constructor);
        return null;
    }

    public int getType() {
        return ERROR;
    }
    
}
