/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification.hints;

import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.j2ee.verification.*;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.util.NbBundle;

/**
 *
 * @author Tomasz Slota
 */
public abstract class RemoveElementHint extends JEEVerificationHint {
    /**
     * Creates a new instance of RemoveElementHint
     */
    public RemoveElementHint(JEEVerificationContextInfo problemContext) {
        super(problemContext);
    }
    
    public int getType() {
        return ERROR;
    }
    
    public static class RemoveAnnotationAttributeHint extends RemoveElementHint{
        private String text;
        
        public RemoveAnnotationAttributeHint(JEEVerificationContextInfo problemContext){
            super(problemContext);
            
            String elementName = null; 
            JavaModel.getJavaRepository().beginTrans(false);
            
            try{
                elementName = ((AttributeValue)getProblemContext().getElement()).getName();
            }
            finally{
                JavaModel.getJavaRepository().endTrans(false);
            }
            text = NbBundle.getMessage(this.getClass(), "MSG_RemoveAnnotationAttribute", elementName);
        }
        
        public ChangeInfo implement() {
            JavaModel.getJavaRepository().beginTrans(true);
            
            try{
                JavaModel.setClassPath(getProblemContext().getJavaClass().getResource());
                
                Annotation wsAnn = (Annotation) getProblemContext().getElement().refImmediateComposite();
                wsAnn.getAttributeValues().remove(getProblemContext().getElement());
            } finally{
                JavaModel.getJavaRepository().endTrans(false);
            }
            return null;
        }

        public String getText() {
            return text;
        }
    }
    
    public static class RemoveAnnotationHint extends RemoveElementHint{
        private String text;
        
        public RemoveAnnotationHint(JEEVerificationContextInfo problemContext){
            super(problemContext);
            
            String elementName = null; 
            JavaModel.getJavaRepository().beginTrans(false);
            try{
                Element e = getProblemContext().getElement();
                
                if (e.isValid()){
                    elementName = ((Annotation)e).getTypeName().getName();
                }
            }
            finally{
                JavaModel.getJavaRepository().endTrans(false);
            }
            
            text = NbBundle.getMessage(this.getClass(), "MSG_RemoveAnnotation", elementName);
        }
        
        public ChangeInfo implement() {
            JavaModel.getJavaRepository().beginTrans(true);
            
            try{
                JavaModel.setClassPath(getProblemContext().getJavaClass().getResource());
                
                AnnotableElement parent = (AnnotableElement) getProblemContext().getElement().refImmediateComposite();
                parent.getAnnotations().remove(getProblemContext().getElement());
            } finally{
                JavaModel.getJavaRepository().endTrans(false);
            }
            return null;
        }
        
        
        public String getText() {
            return text;
        }
    }
}
