/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification.hints;

import java.util.Collections;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.editor.hints.spi.ChangeInfo;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.verification.JEEVerificationContextInfo;
import org.netbeans.modules.j2ee.verification.JEEVerificationHint;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.util.NbBundle;

/**
 *
 * @author Tomasz.Slota@Sun.COM
 */
public abstract class CreateAnnotationAbstractHint extends JEEVerificationHint {
    private String annotationName;
    private String annotationClass;
    
    /** Creates a new instance of CreateAnnotationHint */
    public CreateAnnotationAbstractHint(JEEVerificationContextInfo problemContext, String annotationClass) {
        super(problemContext);
        this.annotationClass = annotationClass;
        int dotPos = annotationClass.lastIndexOf('.');
        annotationName = dotPos > -1 ? annotationClass.substring(dotPos+1) : annotationClass;
    }
    
    @Override public String getText(){
        return NbBundle.getMessage(CreateAnnotationAbstractHint.class, "LBL_CreateAnnotation", annotationName);
    }
    
    @Override public ChangeInfo implement() {
        JavaClass javaClass = getProblemContext().getJavaClass();
        
        JavaModel.getJavaRepository().beginTrans(true);
        try {
            JavaModel.setClassPath(javaClass.getResource());
            
            Annotation ann = JMIGenerationUtil.createAnnotation(javaClass, annotationClass, Collections.EMPTY_LIST); //NOI18N
            ((AnnotableElement)getProblemContext().getElement()).getAnnotations().add(ann);
            
        } finally {
            JavaModel.getJavaRepository().endTrans(false);
        }
        
        return null;
    }
    
    @Override public int getType(){
        return ERROR;
    }
}
