/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.ejb.rules.method;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.ejb.EJBAPIProblemFinder;

import java.util.List;

import static org.netbeans.modules.j2ee.verification.ProblemFindingUtils.isAssignableFrom;

/**
 * The throws clause should not include the java.rmi.RemoteException. The
 * methods of the business interface may only throw the java.rmi.RemoteException
 * if the interface extends java.rmi.Remote.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class BMandRemoteExceptionWarning extends AbstractRule {

    @Override public JEEVerificationProblemMark.Severity getSeverity(){
        return JEEVerificationProblemMark.Severity.WARNING;
    }

    public String getId() {
        return EJBAPIProblemFinder.RuleNames.BMandRemoteExceptionWarning;
    }

    protected String getMessageKey() {
        return "MSG_BMandRemoteExceptionWarning"; // NOI18N
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        final String remoteIF = "java.rmi.Remote"; // NOI18N
        return (ctx.isLBI() || ctx.isRBI()) &&
                !isAssignableFrom(remoteIF, ctx.getMainJavaClass()) &&
                super.isApplicable(subject, ctx);
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            Method m = Method.class.cast(subject);
            for (JavaClass e : (List<JavaClass>) m.getExceptions()) {
                if ("java.rmi.RemoteException".equals(e.getName())) { // NOI18N
                    return createProblem(ctx, subject);
                }
            }
        }
        return null;
    }
}
