/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.ejb.rules.clazz;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.ejb.EJBAPIProblemFinder;
import org.netbeans.modules.j2ee.verification.ejb.predicates.clazz.SBSuperClassIsNotSB;

/**
 * A session bean must not extend another session bean.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class SBSuperClassisNotSB extends AbstractRule {

    public SBSuperClassisNotSB() {
        super(new SBSuperClassIsNotSB());
    }

    public String getId() {
        return EJBAPIProblemFinder.RuleNames.SBSuperClassisNotSB;
    }

    protected String getMessageKey() {
        return "MSG_SBExtendsAnotherSB"; // NOI18N
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        return (ctx.isSessionBean()) &&
                super.isApplicable(subject, ctx);
    }
}
