/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.ejb.rules.clazz;

import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.ejb.EJBAPIProblemFinder;
import org.netbeans.modules.j2ee.verification.ejb.predicates.clazz.AnnotatedAsLocal;
import org.netbeans.modules.javacore.api.JavaModel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * It is also an error if @Remote is specified both on the bean class and on the
 * referenced interface and the values differ.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class BeanUsesRBIasRBI extends AbstractRule {

    List<String> incorrectRBIs = new ArrayList<String>();

    public String getId() {
        return EJBAPIProblemFinder.RuleNames.BeanUsesRBIasRBI;
    }

    protected String getMessageKey() {
        return "MSG_BeanUsesLBIasRBI"; // NOI18N
    }

    @Override protected Object[] getMessageParameters() {
        return incorrectRBIs.toArray();
    }

    @Override protected boolean isApplicable(
            Element subject, ProblemFinderContext ctx) {
        return ctx.isSessionBean() &&
                super.isApplicable(subject, ctx);
    }

    @Override public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (isApplicable(subject, ctx)) {
            Collection<String> rbis = ctx.getRBIs();
            for (String rbi : rbis) {
                Type type = JavaModel.getDefaultExtent().getType().resolve(rbi);
                if(type instanceof JavaClass) {
                    JavaClass jc = JavaClass.class.cast(type);
                    if (new AnnotatedAsLocal().evaluate(jc)) {
                        // rbi is annotated as @Local, so report this as a problem
                        incorrectRBIs.add(rbi);
                    }
                }
            }
            if (!incorrectRBIs.isEmpty()) {
                return createProblem(ctx, subject);
            }
        }
        return null;
    }

    @Override public void reset() {
        incorrectRBIs.clear();
    }
}
