/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.ejb.rules.annotation;

import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.ejb.predicates.annotation.ValueAttrHasNonDefaultValuePred;
import org.netbeans.modules.j2ee.verification.ejb.predicates.annotation.RemoteAnnotationPred;
import org.netbeans.modules.j2ee.verification.ejb.predicates.annotation.AnnotatesAClassPred;
import org.netbeans.modules.j2ee.verification.ejb.EJBAPIProblemFinder;

import java.util.Arrays;

/**
 * If an interface is annotated with @Remote, then value attribute
 * must not be specified. In otherwords, if value is specified for @Remote,
 * then it must be annotating a class (not an interface).
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class ValueNotSpecifiedForRemoteAnnotationInterface extends AbstractRule {

    public ValueNotSpecifiedForRemoteAnnotationInterface() {
        super(new AnnotatesAClassPred(),
                Arrays.asList(new RemoteAnnotationPred(),
                        new ValueAttrHasNonDefaultValuePred()));
    }

    public String getId() {
        return EJBAPIProblemFinder.RuleNames.ValueNotSpecifiedForRemoteAnnotationInterface;
    }

    protected String getMessageKey() {
        return "MSG_ValueSpecfiedForRemoteAnnotationInterface"; // NOI18N
    }
}
