/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.ejb.predicates.annotation;

import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.ArrayInitialization;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.modules.j2ee.verification.common.predicates.annotation.AbstractPredicate;
import org.netbeans.modules.j2ee.verification.ejb.EJBAPIAnnotations;

import java.util.List;

import static org.netbeans.modules.j2ee.verification.JEEVerificationAnnotationProvider.*;

/**
 * Is the value attribute specified? If yes, does it have a non-default value?
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class ValueAttrHasNonDefaultValuePred extends AbstractPredicate {
    protected boolean evaluate(Annotation annotation) {
        for (AttributeValue attr :
                (List<AttributeValue>) annotation.getAttributeValues()) {
            final String name = attr.getName();
            // value is optional when it is the only method in an @
            if (name == null ||
                    EJBAPIAnnotations.VALUE.equals(name)) {
                tmpDbg("value=" + attr.getValue());
                final InitialValue value = attr.getValue();
                if (value instanceof ArrayInitialization) {
                    final List elementValues = ArrayInitialization.class.cast(
                            value).getElementValues();
                    return !elementValues.isEmpty(); // allow compiler default
                }
                return true; // value is specified and it is not an empty {}
            }
        }
        return false;
    }

}
