/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.ejb;

import static org.netbeans.modules.j2ee.verification.JEEVerificationAnnotationProvider.*;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.verification.*;
import org.netbeans.modules.j2ee.verification.ejb.rules.annotation.ValueNotSpecifiedForRemoteAnnotationInterface;
import org.netbeans.modules.j2ee.verification.ejb.rules.clazz.*;
import org.netbeans.modules.j2ee.verification.ejb.rules.constructor.PublicConstructor;
import org.netbeans.modules.j2ee.verification.ejb.rules.method.*;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.filesystems.FileObject;

/**
 * This problem finder finds out all JSR 220 EJB related problems in
 * Java source. It has a list of {@link Rule} which it applies on the Java
 * source. The rule list is maintained in {@link #rulesRepository} object.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class EJBAPIProblemFinder extends ProblemFinder {

    // TODO: Refactor code that is common to this class and PersistenceAPIProblemFinder

    /**
     * Repository of all the rules applicable to EJB API.
     */
    private static RulesRepository rulesRepository;

    /**
     * This rule walks through all the elements in the {@link JavaClass} and its
     * children and applies rules that are applicable to each element type.
     *
     * @see org.netbeans.modules.j2ee.verification.RulesEngine
     * @see org.netbeans.modules.j2ee.verification.RulesRepository
     * @see #getProblemMarks()
     */
    public void parseDocument() {
        if (!isApplicable()) {
            return;
        }
        final ProblemFinderContext context = getContext();
        JavaClass javaClass = context.getMainJavaClass();
        RulesEngine.ErrorHandler errorHandler = new RulesEngine.ErrorHandler() {
            public void onError(Problem problem, Rule rule) {
                JEEVerificationProblemMark problemMark =
                        new JEEVerificationProblemMark(rule.getId(),
                                problem.getMessage(),
                                problem.getProblemContext(),
                                rule.getSeverity());
                attachProblemMarkToElement(problemMark,
                        problem.getProblemContext().getElement());
                addProblemMark(problemMark);
            }
        };
        RulesEngine rulesEngine = new RulesEngine(errorHandler, context,
                rulesRepository);

        // now apply rules recurssively
        new TreeWalker(rulesEngine).visitClass(javaClass);
    }

    protected boolean isApplicable() {
        final ProblemFinderContext context = getContext();
        JavaClass javaClass = context.getMainJavaClass();
        FileObject fo = JavaModel.getFileObject(javaClass.getResource());
        
        if (fo != null) // fo can be null if the class has just been deleted
        {
            Project project = FileOwnerQuery.getOwner(fo);
            if (project != null) {
                J2eeModuleProvider j2eeModuleProvider = J2eeModuleProvider.class.cast(
                        project.getLookup().lookup(J2eeModuleProvider.class));
                if (j2eeModuleProvider != null) {
                    J2eeModule j2eeModule = j2eeModuleProvider.getJ2eeModule();
                    if (j2eeModule != null) {
                        Object type = j2eeModule.getModuleType();
                        double version = Double.parseDouble(j2eeModule.getModuleVersion());
                        if (J2eeModule.EJB.equals(type) && (version > 2.1)) {
                            tmpDbg("Project module type is EJB 3.0 or higher, " +
                                    "so activating EJB verification rules engine.");
                            return true;
                        }
                    }
                }
            }
        }
        
        return false;
    }

    // temporarily maintain list of all rule names here.
    public static interface RuleNames {
        String ValueNotSpecifiedForRemoteAnnotationInterface =
                "ValueNotSpecifiedForRemoteAnnotationInterface"; // NOI18N

        String NonFinalClass = "NonFinalClass"; // NOI18N

        String PublicClass = "PublicClass"; // NOI18N

        String HasNoArgConstructor = "HasNoArgConstructor"; // NOI18N

        String NoFinalizeMethod = "NoFinalizeMethod"; // NOI18N

        String SBSuperClassisNotSB = "SBSuperClassisNotSB"; // NOI18N

        String NonAbstractClass = "NonAbstractClass"; // NOI18N

        String TopLevelClass = "TopLevelClass"; // NOI18N

        String PublicConstructor = "PublicConstructor"; // NOI18N

        String SessionSynchImplementedBySFSBOnly =
                "SessionSynchImplementedBySFSBOnly"; // NOI18N

        String BIDoesNotExtendsEJBObject = "BIDoesNotExtendsEJBObject"; // NOI18N

        String BeanHasDifferentLBIandRBI = "BeanHasDifferentLBIandRBI"; // NOI18N

        String LocalAnnotatedBeanHasLBI = "LocalAnnotatedBeanHasLBI"; // NOI18N

        String RemoteAnnotatedBeanHasRBI = "RemoteAnnotatedBeanHasRBI"; // NOI18N

        String BeanUsesRBIasRBI = "BeanUsesRBIasRBI"; // NOI18N

        String BeanUsesLBIasLBI = "BeanUsesLBIasLBI"; // NOI18N

        String WSisSLSB = "WSisSLSB"; // NOI18N

        String SFSBdoesNotImplementTimedObject =
                "SFSBdoesNotImplementTimedObject"; // NOI18N

        String BeanImplementsBI = "BeanImplementsBI"; // NOI18N

        String BMandRemoteExceptionWarning = "BMandRemoteExceptionWarning"; // NOI18N

        String LBIdoesNotExtendRemote = "LBIdoesNotExtendRemote"; // NOI18N

        String BMnotPartOfRBIandLBI = "BMnotPartOfRBIandLBI"; // NOI18N
    }

    // Temporarily add all the rules here.
    // TODO: We should read this from an external source like XML.
    static {
        try {
            rulesRepository = new RulesRepository();

            // class level rules
            rulesRepository.registerClazzRule(
                    NonFinalClass.class.getName());
            rulesRepository.registerClazzRule(
                    NonAbstractClass.class.getName());
            rulesRepository.registerClazzRule(
                    PublicClass.class.getName());
            rulesRepository.registerClazzRule(
                    TopLevelClass.class.getName());
            rulesRepository.registerClazzRule(
                    SBSuperClassisNotSB.class.getName());
            rulesRepository.registerClazzRule(
                    HasNoArgConstructor.class.getName());
            rulesRepository.registerClazzRule(
                    NoFinalizeMethod.class.getName());
            rulesRepository.registerClazzRule(
                    SessionSynchImplementedBySFSBOnly.class.getName());
            rulesRepository.registerClazzRule(
                    BIDoesNotExtendsEJBObject.class.getName());
            rulesRepository.registerClazzRule(
                    BeanHasDifferentLBIandRBI.class.getName());
            rulesRepository.registerClazzRule(
                    LocalAnnotatedBeanHasLBI.class.getName());
            rulesRepository.registerClazzRule(
                    RemoteAnnotatedBeanHasRBI.class.getName());
            rulesRepository.registerClazzRule(
                    BeanUsesLBIasLBI.class.getName());
            rulesRepository.registerClazzRule(
                    BeanUsesRBIasRBI.class.getName());
            rulesRepository.registerClazzRule(
                    WSisSLSB.class.getName());
            rulesRepository.registerClazzRule(
                    SFSBdoesNotImplementTimedObject.class.getName());
            rulesRepository.registerClazzRule(
                    BeanImplementsBI.class.getName());
            rulesRepository.registerClazzRule(
                    LBIdoesNotExtendRemote.class.getName());

            // annotation level rules
            rulesRepository.registerAnnotationRule(
                    ValueNotSpecifiedForRemoteAnnotationInterface.class.getName());

            // constructor level rules
            rulesRepository.registerConstructorRule(
                    PublicConstructor.class.getName());
            
            // method level rules
            rulesRepository.registerMethodRule(
                    BMandRemoteExceptionWarning.class.getName());
//            rulesRepository.registerMethodRule( // TODO: Not Yet Implemented
//                    BMnotPartOfRBIandLBI.class.getName());

            // field level rules
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

}
