/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification.common.predicates.member;

import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.TypedElement;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;

/**
 * @author Tomasz.Slota@Sun.COM
 */
public class IsEntityTypePred extends AbstractPredicate {
    protected boolean evaluate(ClassMember member) {
        String type = ((TypedElement)member).getType().getName();
        EntityMappings mappings = PersistenceAPIHelper.getEntityMappings(member);
        Entity e = mappings == null ? null : PersistenceUtils.getEntity(type, mappings);
        boolean isEntityType = e != null;
        return !isEntityType;
    }
}
