/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.common.predicates.clazz;

import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.metadata.Constants;

import java.util.List;

/**
 * Is this class Serializable? A class is serializable if itself or any of its
 * super classes implements java.io.Serializable interface.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class SerializableClassPred extends AbstractPredicate {

    protected boolean evaluate(JavaClass javaClass) {
        if (javaClass.getName().equals(Constants.OBJECT)) { // break recurssion
            return false;
        }
        // See javadocs of JavaClass.getInterfaces().
        // It returns a list of interfaces that a class implements or
        // a list of interfaces that an interface extends.
        for (JavaClass intf : (List<JavaClass>) javaClass.getInterfaces()) {
            if (intf.getName().equals(Constants.SERIALIZABLE)) {
                return true;
            }
            ;
            // recurssively see if any of the implemented interfaces is Serializable
            if (evaluate(intf)) return true;
        }
        // search all super classes recurssively
        return (evaluate(javaClass.getSuperClass()));
    }

}
