/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification.common.predicates.clazz;

import org.netbeans.jmi.javamodel.*;
import org.netbeans.modules.javacore.api.JavaModel;

import java.util.List;
import java.util.Arrays;

/**
 * Does this class override {@link java.lang.Object#equals}
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class OverridesEqualsMethodPred extends AbstractPredicate {
    protected boolean evaluate(JavaClass javaClass) {
        Type type = JavaModel.getDefaultExtent().getType().resolve(
                "java.lang.Object"); // NOI18N
        final Method method = javaClass.getMethod("equals", // NOI18N
                Arrays.asList(type),
                false);
        return method!= null;
//        for (ClassMember cm : (List<ClassMember>) javaClass.getContents()) {
//            if (cm instanceof Method) {
//                Method method = Method.class.cast(cm);
//                if (method.getName().equals("equals")) {  // NOI18N
//                    List<Parameter> params = method.getParameters();
//                    if (params.size() == 1) {
//                        Type paramType = params.get(0).getType();
//                        if (paramType != null && // resolved
//                                paramType.getName().equals("java.lang.Object")) { // NOI18N
//                            return true;
//                        }
//                    }
//                }
//            }
//        }
//        return false;
    }

}
