/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification;

import java.util.ArrayList;
import java.util.Collection;

import static java.util.Collections.*;

/**
 * As the name suggests, this class reprsents a repository of rules.
 * This is used by {@link RulesEngine}
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class RulesRepository {

    // TODO: Convert this to an interface and implementation pair.
    // TODO: Add ability to read rules data from an XML source.

    /**
     * Rules that are applicable to {@link org.netbeans.jmi.javamodel.JavaClass}
     * element type.
     */
    private Collection<Rule> clazzRules = new ArrayList<Rule>();

    /**
     * Rules that are applicable to {@link org.netbeans.jmi.javamodel.Constructor}
     * element type.
     */
    private Collection<Rule> constructorRules = new ArrayList<Rule>();

    /**
     * Rules that are applicable to {@link org.netbeans.jmi.javamodel.Field}
     * element type.
     */
    private Collection<Rule> fieldRules = new ArrayList<Rule>();

    /**
     * Rules that are applicable to {@link org.netbeans.jmi.javamodel.Method}
     * element type.
     */
    private Collection<Rule> methodRules = new ArrayList<Rule>();

    /**
     * Rules that are applicable to {@link org.netbeans.jmi.javamodel.Annotation}
     * element type.
     */
    private Collection<Rule> annotationRules = new ArrayList<Rule>();

    /**
     * @return a read-only collection of rules applicable at class level.
     */
    public Collection<Rule> getClazzRules() {
        return unmodifiableCollection(clazzRules);
    }

    /**
     * @return a read-only collection of rules applicable at constructor level.
     */
    public Collection<Rule> getConstructorRules() {
        return unmodifiableCollection(constructorRules);
    }

    /**
     * @return a read-only collection of rules applicable at field level.
     */
    public Collection<Rule> getFieldRules() {
        return unmodifiableCollection(fieldRules);
    }

    /**
     * @return a read-only collection of rules applicable at method level.
     */
    public Collection<Rule> getMethodRules() {
        return unmodifiableCollection(methodRules);
    }

    /**
     * @return a read-only collection of rules applicable at method level.
     */
    public Collection<Rule> getAnnotationRules() {
        return annotationRules;
    }

    public void registerClazzRule(String className)
            throws ClassNotFoundException, IllegalAccessException,
            InstantiationException {
        clazzRules.add(Rule.class.cast(Class.forName(className).newInstance()));
    }

    public void registerFieldRule(String className)
            throws ClassNotFoundException, IllegalAccessException,
            InstantiationException {
        fieldRules.add(Rule.class.cast(Class.forName(className).newInstance()));
    }

    public void registerConstructorRule(String className)
            throws ClassNotFoundException, IllegalAccessException,
            InstantiationException {
        constructorRules.add(Rule.class.cast(
                Class.forName(className).newInstance()));
    }

    public void registerMethodRule(String className)
            throws ClassNotFoundException, IllegalAccessException,
            InstantiationException {
        methodRules.add(
                Rule.class.cast(Class.forName(className).newInstance()));
    }

    public void registerAnnotationRule(String className)
            throws ClassNotFoundException, IllegalAccessException,
            InstantiationException {
        annotationRules.add(
                Rule.class.cast(Class.forName(className).newInstance()));
    }
}
