/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */


package org.netbeans.modules.j2ee.verification;

import org.netbeans.editor.BaseDocument;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.verification.persistence.BeanAccessType;
import org.openide.ErrorManager;
import org.openide.text.Line;

import java.util.ArrayList;
import java.util.Collection;

/**
 * A base class for persistence API problem finders.
 *
 * @author Tomasz Slota
 */
public abstract class ProblemFinder {

    private final Collection<JEEVerificationProblemMark> problemMarks = new ArrayList<JEEVerificationProblemMark>();
    private ProblemFinderContext context;

    public abstract void parseDocument();
    
    protected void addProblemMark(JEEVerificationProblemMark problem){
        getProblemMarks().add(problem);
    }
    
    protected void attachProblemMarkToElement(JEEVerificationProblemMark problemMark, Element element){
        Line.Part linePart = ProblemFindingUtils.getLinePartForElement(getLineSet(), getDocument(), element);
        problemMark.attach(linePart);
        JEEVerificationAnnotationProvider.tmpDbg("problemMark attached: " + problemMark); //NOI18N
    }
    
    protected void attachProblemMarkToModifier(JEEVerificationProblemMark problemMark, ClassMember element, int modifier){
        if ((element.getModifiers() & modifier) == 0){
            throw new IllegalArgumentException("Specified element does not contain specified modifier"); //NOI18N
        }
        
        Line.Part linePart = ProblemFindingUtils.getLinePartForModifier(getLineSet(), getDocument(), element, modifier);
        
        if (linePart != null){
            problemMark.attach(linePart);
        }
        else{
            ErrorManager.getDefault().log(ErrorManager.ERROR, "failed to attach the problem mark to the modifier"); //NOI18N
            attachProblemMarkToElement(problemMark, element);
        }
    }
    
    public ProblemFinderContext getContext() {
        return context;
    }

    public final Collection<JEEVerificationProblemMark> getProblemMarks() {
        return problemMarks;
    }
    
    public final void  reset(){
        problemMarks.clear();
    }
    
    public Line.Set getLineSet() {
        return context.getLineSet();
    }
    
    public Resource getResource() {
        return context.getResource();
    }
    
    public BaseDocument getDocument() {
        return context.getDocument();
    }
    
    public JavaClass getMainJavaClass() {
        return context.getMainJavaClass();
    }

    public BeanAccessType getBeanAccessType() {
        return context.getBeanAccessType();
    }

    public boolean getIsEntityClass() {
        return context.isIsEntityClass();
    }

    void setContext(ProblemFinderContext context) {
        this.context = context;
    }
    
    /**
     * If 'e' is annotatated with annotation named 'annotationName' returns the annotation,
     * otherwise returns 'e'. 
     * Useful when working with a model created from merged annotation/xml descriptor data
     */
    protected static Element getAnnotationOrAnnotableElement(AnnotableElement elem, String annotationName){
        Annotation ann = ProblemFindingUtils.findAnnotation(elem, annotationName);
        
        if (ann != null){
            return ann;
        }
        
        return elem;
    }
}
