/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;


/**
 * This class represents error annotation for problems related to the persistence API.
 *
 * @author Tomasz Slota
 */
public class JEEVerificationProblemMark {
    private String problemId;
    private JEEVerificationContextInfo problemContext;
    private Severity severity = Severity.ERROR;
    private JEEVerificationAnnotation annotation;
    private Annotatable attachedAnnotable;
    
    public enum Severity {HINT, ERROR, WARNING, PORTABILITY_ERROR, PORTABILITY_WARNING};
    
    public JEEVerificationProblemMark(String problemId, String errorMsg, JEEVerificationContextInfo problemContext) {
        this(problemId, errorMsg, problemContext, Severity.ERROR);
    }
    
    public JEEVerificationProblemMark(String problemId, String errorMsg, JEEVerificationContextInfo problemContext, Severity severity){
        this.severity = severity;
        this.problemId = problemId;
        this.problemContext = problemContext;
        
        if (severity != Severity.HINT){
            annotation = new JEEVerificationAnnotation(errorMsg, severity);
        }
    }
    
    public String getProblemId() {
        return problemId;
    }
    
    public JEEVerificationContextInfo getProblemContext() {
        return problemContext;
    }
    
    @Override public String toString(){
        String pos = "[unbound]"; //NOI18N
        
        if (getAttachedAnnotatable() != null){
            if (getAttachedAnnotatable() instanceof Line.Part){
                Line.Part linePart = (Line.Part)getAttachedAnnotatable();
                pos = "[line=" + Integer.toString(linePart.getLine().getLineNumber()) + ", col=" //NOI18N
                        + linePart.getColumn() + ", len=" + linePart.getLength() + "]"; //NOI18N
            } else if (getAttachedAnnotatable() instanceof Line) {
                pos = "[line=" + Integer.toString(((Line)getAttachedAnnotatable()).getLineNumber()) + "]"; //NOI18N
            }
        }
        
        return pos + " id='" + problemId + "', severity=" + severity; //NOI18N
    }
    
    public void detach(){
        if (annotation != null){
            annotation.detach();
        }
    }
    
    public void attach(Annotatable ann){
        if (annotation != null){
            annotation.attach(ann);
        } else{
            attachedAnnotable = ann;
        }
    }
    
    Annotatable getAttachedAnnotatable(){
        if (annotation != null){
            return annotation.getAttachedAnnotatable();
        }
        
        if (attachedAnnotable == null){
            throw new IllegalStateException("Problem mark " + problemId //NOI18N
                    + " is not attached to sources"); //NOI18N
        }
        
        return attachedAnnotable;
    }
    
    private static class JEEVerificationAnnotation extends Annotation{
        private final Severity severity;
        private final String errorMsg;
        
        public JEEVerificationAnnotation(String errorMsg, Severity severity){
            this.errorMsg = errorMsg;
            this.severity = severity;
        }
        
        public String getAnnotationType() {
            // TODO: distinguish portability errors/warnings 
            return severity == Severity.ERROR || severity == Severity.PORTABILITY_ERROR ?
                    "org-netbeans-modules-j2ee-verification-PersistenceAPIErrorMark" //NOI18N
                  : "org-netbeans-modules-j2ee-verification-PersistenceAPIWarningMark"; //NOI18N
        }
        
        public String getShortDescription() {
            return errorMsg;
        }
    }
}


