/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.hints.spi.HintsProvider;
import org.openide.ErrorManager;
import org.openide.text.Line;

/**
 *
 * @author Tomasz Slota    
 */
public class JEEVerificationHintsProvider extends HintsProvider {
    
    private static JEEVerificationHintsProvider INSTANCE;
    
    static synchronized JEEVerificationHintsProvider getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JEEVerificationHintsProvider();
        }
        return INSTANCE;
    }
    
    /**
     * Creates a new instance of JEEVerificationHintsProvider
     */
    private JEEVerificationHintsProvider() {
    }

    public List getHints(Document doc, int offset) {
        
        if (!(doc instanceof BaseDocument)) {
            return Collections.EMPTY_LIST; //TODO: do we really hv to check it??
        }
        
        BaseDocument baseDoc = (BaseDocument) doc;
        Collection<JEEVerificationProblemMark> jeeProblems = (Collection<JEEVerificationProblemMark>) baseDoc.getProperty(JEEVerificationAnnotationProvider.JEE_PROBLEM_SCANNING_RESULT);
        Line.Set origLineSet = (Line.Set) baseDoc.getProperty(JEEVerificationAnnotationProvider.JEE_PROBLEM_SCANNING_LINESET);
        
        if (jeeProblems == null || origLineSet == null){
            return Collections.EMPTY_LIST;
        }
        
        List<JEEVerificationHint> returnValue = new ArrayList<JEEVerificationHint>();
        
        try {
            int cursorPosLine = Utilities.getLineOffset(baseDoc, offset);       
            
            synchronized (jeeProblems){
                for (JEEVerificationProblemMark error:jeeProblems){
                    Line.Part linePart = (Line.Part)error.getAttachedAnnotatable();
                    int originalLineNumber = linePart.getLine().getLineNumber();
                    Line currentLine = origLineSet.getCurrent(originalLineNumber);
                    
                    if (currentLine != null){ // the line may not exist anymore, see issue #84645
                        int errorLineNum = currentLine.getLineNumber();
                        
                        if (cursorPosLine == errorLineNum){
                            JEEVerificationHint problemHints[] = HintsManager.getHintsForProblem(error);
                            
                            if (problemHints != null){
                                for (JEEVerificationHint hint : problemHints){
                                    if (!returnValue.contains(hint)){
                                        returnValue.add(hint);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            
        } catch (BadLocationException e) {
            ErrorManager.getDefault().notify(ErrorManager.INFORMATIONAL, e);
        }   
        
        return returnValue;
    }
    
    public void update(Document doc){
        firePropertyChangeEvent(PROP_REFRESH, null, doc);
    }
}
