/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.modules.j2ee.verification;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openide.ErrorManager;

/**
 *
 * @author Tomasz Slota
 */
public class HintsManager {
    private static Map problemToHintsMapping = new Hashtable();
    
    /** No instantialization allowed */
    private HintsManager() {
        //kshdsjkd
    }
    
    public static JEEVerificationHint[] getHintsForProblem(JEEVerificationProblemMark problem){
        List hintClasses = (List)problemToHintsMapping.get(problem.getProblemId());
        List retunValue = new ArrayList();
        
        if (hintClasses != null){
            for (Iterator it = hintClasses.iterator(); it.hasNext();){
                String hintClassname = (String)it.next();
                JEEVerificationHint hint = createJEEHint(hintClassname, problem.getProblemContext());
                
                if (hint != null){
                    retunValue.add(hint);
                }
            }
        }
        
        return (JEEVerificationHint[]) retunValue.toArray(new JEEVerificationHint[0]);
    }
    
    public static void registerHint(String problemId, String hintClass){
        List hintsForAProblem = (List)problemToHintsMapping.get(problemId);
        
        if (hintsForAProblem == null){
            hintsForAProblem = new ArrayList();
            problemToHintsMapping.put(problemId, hintsForAProblem);
        }
        
        hintsForAProblem.add(hintClass);
    }
    
    private static JEEVerificationHint createJEEHint(String className, JEEVerificationContextInfo problemContext){
        JEEVerificationHint returnValue = null;
        try {
            Class classDef = Class.forName(className);
            Class constrArgs[] = new Class[]{JEEVerificationContextInfo.class};
            Constructor constr = classDef.getConstructor(constrArgs);
            returnValue = (JEEVerificationHint)constr.newInstance(new Object[]{problemContext});
            
        } catch (Exception e) {
            ErrorManager.getDefault().notify(ErrorManager.EXCEPTION, e);
        }
        
        return returnValue;
    }
}
