/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.common.ui.nodes;

import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.modules.j2ee.dd.api.ejb.MethodParams;
import org.netbeans.modules.j2ee.dd.api.ejb.Query;
import org.netbeans.modules.j2ee.dd.api.ejb.QueryMethod;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;




/**
 * @author pfiala
 */
public class QueryCustomizer {

    private MethodCustomizer methodCustomizer;


    public boolean showFinderCustomizer(Method methodElement, Query query, boolean returnsCollection,
            boolean hasLocalInterface, boolean hasRemoteInterface, boolean hasLocalMethod, boolean hasRemoteMethod) {

        // TODO: (madamek) Method[] mes parameter should be array of classes for class signature validation
        //  use JMIUtils.getMethods(..)
        //  the way it is now (with empty array) it allows to enter any method signature (see issue 50405)
        methodCustomizer =
                MethodCollectorFactory.finderCollector(methodElement, hasRemoteInterface, hasLocalInterface, true, new Method[0], hasRemoteInterface, hasLocalInterface);
        methodCustomizer.setFinderCardinality(returnsCollection);
        methodCustomizer.setPublishToLocal(hasLocalMethod);
        methodCustomizer.setPublishToRemote(hasRemoteMethod);
        String title = NbBundle.getMessage(QueryCustomizer.class, "LBL_EditFinderMethod");
        return showDialog(methodElement, title, query);
    }

    private boolean showDialog(Method methodElement, String title, Query query) {
        methodCustomizer.setEjbQL(query.getEjbQl());
        final NotifyDescriptor nd = new NotifyDescriptor(methodCustomizer, title, NotifyDescriptor.OK_CANCEL_OPTION,
                NotifyDescriptor.PLAIN_MESSAGE, null, null);
        methodCustomizer.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(MethodCustomizer.OK_ENABLED)) {
                    Object newvalue = evt.getNewValue();
                    if ((newvalue != null) && (newvalue instanceof Boolean)) {
                        nd.setValid(((Boolean)newvalue).booleanValue());
                    }
                }
            }
        });
        Object result = DialogDisplayer.getDefault().notify(nd);
        methodCustomizer.isOK(); // apply possible changes in dialog fields
        if (result == NotifyDescriptor.OK_OPTION) {
            updateQueryMethod(query, methodElement);
            query.setEjbQl(methodCustomizer.getEjbQL());
            return true;
        } else {
            return false;
        }
    }

    private static void updateQueryMethod(Query query, Method methodElement) {
        QueryMethod queryMethod = query.newQueryMethod();
        queryMethod.setMethodName(methodElement.getName());
        MethodParams methodParams = queryMethod.newMethodParams();
        Parameter[] parameters = (Parameter[]) methodElement.getParameters().toArray(new Parameter[methodElement.getParameters().size()]);
        for (int i = 0; i < parameters.length; i++) {
            methodParams.addMethodParam(parameters[i].getType().getName());
        }
        queryMethod.setMethodParams(methodParams);
        query.setQueryMethod(queryMethod);
    }

    public boolean showSelectCustomizer(Method methodElement, Query query) {
        methodCustomizer = MethodCollectorFactory.selectCollector(methodElement, new Method[0]);
        String title = NbBundle.getMessage(QueryCustomizer.class, "LBL_EditSelectMethod");
        return showDialog(methodElement, title, query);
    }


    public boolean finderReturnIsSingle() {
        return methodCustomizer.finderReturnIsSingle();
    }

    public boolean publishToRemote() {
        return methodCustomizer.publishToRemote();
    }

    public boolean publishToLocal() {
        return methodCustomizer.publishToLocal();
    }
}
