/*
 * The contents of this file are subject to the terms of the Common Development
 * and Distribution License (the License). You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the License at http://www.netbeans.org/cddl.html
 * or http://www.netbeans.org/cddl.txt.
 * 
 * When distributing Covered Code, include this CDDL Header Notice in each file
 * and include the License file at http://www.netbeans.org/cddl.txt.
 * If applicable, add the following below the CDDL Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.modules.j2ee.common.ui.nodes;

import java.awt.Image;
import java.lang.reflect.Modifier;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.InstanceEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.java.ui.nodes.SourceNodeFactory;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.netbeans.modules.javacore.JMManager;
import org.openide.ErrorManager;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import javax.swing.Action;
import org.openide.actions.OpenAction;
import org.openide.cookies.OpenCookie;
import org.openide.text.PositionBounds;
import org.openide.util.actions.SystemAction;
import org.openide.util.Utilities;
import java.util.Collection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.jmi.javamodel.Method;
import org.openide.nodes.Children;

import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;


public class MethodNode extends FilterNode implements MDRChangeListener, OpenCookie {
    private Method method;
    private ComponentMethodViewStrategy cmvs;
    private Collection interfaces;
    private JavaClass implBean;
    
    public MethodNode(Method method, JavaClass implBean, Collection interfaces, ComponentMethodViewStrategy cmvs) {
        this(method,implBean,interfaces,cmvs, new InstanceContent());
    }
    
    private MethodNode(Method method, JavaClass implBean, Collection interfaces, ComponentMethodViewStrategy cmvs, InstanceContent ic) {
        super(createMethodElementNode(method),
              Children.LEAF, new AbstractLookup(ic));
        ic.add(this);
        ic.add(method);
        disableDelegation(FilterNode.DELEGATE_DESTROY);
        this.method = method;
        this.implBean = implBean;
        this.interfaces = interfaces;
        this.cmvs = cmvs;
        // TODO: listeners - WeakListener was used here before change to JMI, how to use it now?
        // unregister in appropriate point or play with ActiveQueue (openide utilities)
        ((MDRChangeSource) method).addListener(this);  
    }
    
    private static Node createMethodElementNode(Method method) {
        SourceNodeFactory snf = SourceNodes.getExplorerFactory();
        return snf.createMethodNode(method);
    }
    
    public Image getIcon(int type) {
        Image badge = cmvs.getBadge(method, interfaces);
        Image icon = cmvs.getIcon(method, interfaces);
        if(badge != null){
            return Utilities.mergeImages(icon, badge, 7,7);
        }
        return icon;
    }
    
    public boolean canDestroy() {
        if ("findByPrimaryKey".equals(method.getName())) { //NOI18N
            if (isEntityBeanMethod()) {
                return false;
            }
        } else if (Modifier.isAbstract(method.getModifiers()) &&
                (isGetter(method) || isSetter(method)) && isEntityBeanMethod()) {
            return false;
        }
        return true;
    }
    
    public void destroy() throws IOException {
        ((MDRChangeSource) method).removeListener(this);  
        cmvs.deleteImplMethod(method, implBean, interfaces);
        super.destroy();
    }
    
    public void change(MDRChangeEvent e) {
        // TODO: listeners - filtering of events is possible. Is it needed?
        fireIconChange();
    }
    
    public Action[] getActions(boolean context) {
        List l = new ArrayList(Arrays.asList(getOriginal().getActions(context)));
        return (Action[]) l.toArray(new Action[l.size()]);
    }
    
    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }
    
    private void refreshImplBean() {
        // TODO: need this refresh? if so, how to ensure with JMI?
//        ClassElement ce = implBeanSrc.getClass(className);
//        if (ce != null) {
//            implBean = ce;
//        }
    }
    
    //implementation of OpenCookie
    public void open() {
        refreshImplBean();
        OpenCookie cookie = cmvs.getOpenCookie(method,implBean, interfaces);
        if(cookie != null){
            cookie.open();
            Method methodInImplBean = JMIUtils.findInClass(method, implBean);
            JMIUtils.openInEditor(methodInImplBean == null ? method : methodInImplBean); // try to open in impl bean, otherwise in intf
        }
    }

    private boolean isEntityBeanMethod() {
        refreshImplBean();
        JavaClass entityBean = (JavaClass)((JavaModelPackage)implBean.refImmediatePackage()).getJavaClass().resolve("javax.ejb.EntityBean"); //NOI18N
        if (implBean.isSubTypeOf(entityBean)) {
            return true;
        }
        return false;
    }

    private boolean isGetter(Method method) {
        Type type = method.getType();
        boolean isVoid = (type instanceof PrimitiveType) && 
                ((PrimitiveType) type).getKind().equals(PrimitiveTypeKindEnum.VOID);
        if (method.getName().indexOf("get") == 0 &&
            !isVoid &&
            method.getParameters().size() == 0) {
            return true;
        }
        return false;
    }
    
    private boolean isSetter(Method method) {
        Type type = method.getType();
        boolean isVoid = (type instanceof PrimitiveType) && 
                ((PrimitiveType) type).getKind().equals(PrimitiveTypeKindEnum.VOID);
        if (method.getName().indexOf("set") == 0 &&
            isVoid &&
            method.getParameters().size() == 1) {
            return true;
        }
        return false;
    }

}

